<?php
/**
* @version	$Id: gift_certificates_eh.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class GiftCertificateEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
			'OnItemBuild' => Array('self' => true),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	function OnApplyClone(&$event)
	{
		$item = &$event->getObject();
		$clone_count = $this->Application->GetVar('clone_items_count');
		$table = $this->Application->getUnitOption($event->Prefix, 'TableName');
		if ($clone_count && $clone_count>0){
			$this->Application->StoreVar('CoupLastCloneCount', $clone_count);
			for ($i=0; $i<$clone_count; $i++)			{
				$this->SetNewCode($item);

				$item->SetField('Expiration_date', $this->Application->GetVar('clone_exp_date'));
				$item->SetField('Expiration_time', $this->Application->GetVar('clone_exp_time'));
				$item->NameCopy();
				$validated = $item->Create();


			}
		}

		if ($validated){
			$this->finalizePopup($event);
		}else{
			$event->redirect = false;
		}
	}

	function SetNewCode(&$item)
	{
		do{
			$new_code = $this->RandomCouponCode(10);
			$exists = $this->Conn->GetOne('SELECT COUNT(*) FROM '.TABLE_PREFIX.'ProductsCoupons WHERE Code='.$this->Conn->qstr($new_code));
			if ($exists){
				$new_code = false;
			}
		} while (!$new_code);

		$item->SetDBField('Code', $new_code);
	}

	function RandomCouponCode($size)
	{
		$rand_code = "";
		for ($i=0; $i<10; $i++){
			$is_letter = rand(0,1);
			if ($is_letter){
				$rand_char = chr(rand(65,90));
			}else{
				$rand_char = rand(0,9);
			}
			$rand_code .= $rand_char;
		}
		return $rand_code;
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnApplyGiftCertificate(&$event)
	{
		$code = $this->Application->GetVar('giftcert_code');
		if ($code == '') {
			return ;
		}

		$object =& $event->getObject(Array('skip_autoload' => true));
		$object->Load($code, 'Code');

		if (!$object->isLoaded()) {
			$event->status = erFAIL;
			$this->Application->SetVar('set_checkout_error', 104);
			$event->redirect = false; // check!!!
			return ;
		}

		$expire_date = $object->GetDBField('Expiration');
		$debit = $object->GetDBField('Debit');
		if(	$object->GetDBField('Status') != 1 || ($expire_date && $expire_date < adodb_mktime()) ||
		($debit <= 0))
		{
			$event->status = erFAIL;
			$this->Application->SetVar('set_checkout_error', 105);
			$event->redirect->false;
			return ;
		}

		$this->Application->setUnitOption('ord', 'AutoLoad', true);
		$order =& $this->Application->recallObject('ord');
		$order->SetDBField('GiftCertificateId', $object->GetDBField('GiftCertificateId'));
		$order->Update();

		$this->Application->SetVar('set_checkout_error', 110);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnPreCreate(&$event)
	{
		parent::OnPreCreate($event);

		$object = &$event->getObject();
		$exp_date = adodb_mktime();

		$default_duration = $this->Application->ConfigValue('Comm_DefaultCouponDuration');

		if ($default_duration && $default_duration > 0){
			$exp_date += (int)$default_duration * 86400;
		}
		$object->SetDBField('Expiration_date', $exp_date);
	}

	function OnBeforeItemUpdate(&$event)
	{
		$object =& $event->getObject();
		/* @var $object kDBItem */
		$amount = abs($object->GetDBField('Amount'));
		$debit = abs($object->GetDBField('Debit'));

		if ($debit > $amount) {
			$debit = $amount;
		}
		$object->SetDBField('Amount', $amount);
		$object->SetDBField('Debit', $debit);

		if ($object->GetDBField('SendVia') == 1) {
			// by postal mail
			if ($this->Application->GetVar('email_certificate') == 0) {
				$object->setRequired('RecipientEmail', false);
			}

			$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
			/* @var $cs_helper kCountryStatesHelper */

			if (!$cs_helper->CountryHasStates($object->GetDBField('RecipientCountry'))) {
				$object->setRequired('RecipientState', false);
			}
			$cs_helper->CheckStateField($event, 'RecipientState', 'RecipientCountry');
		} else {
			$non_required_fields = Array (
				'RecipientState', 'RecipientCity', 'RecipientCountry',
				'RecipientZipcode', 'RecipientAddress1', 'RecipientFirstname',
				'RecipientLastname',
			);

			foreach ($non_required_fields as $non_required_field) {
				$object->setRequired($non_required_field, false);
			}
		}
	}

	function OnBeforeItemCreate(&$event)
	{
		$this->OnBeforeItemUpdate($event);

		$object =& $event->getObject();
		/* @var $object kDBItem */
		$object->SetDBField('Debit', $object->GetDBField('Amount'));
	}

	/**
	 * Print current gift certiicate
	 *
	 * @param kEvent $event
	 */
	function OnSave(&$event)
	{
		parent::OnSave($event);

		if ($event->status == erSUCCESS) {
 			$object =& $event->getObject();
 			/* @var $object kDBItem */

 			if ($this->Application->GetVar('print_certificate') == 1) {
				// get object id by unique field Code
 				$sql = 'SELECT '.$object->IDField.'
 						FROM '.$this->Application->GetLiveName($object->TableName).'
 						WHERE Code = '.$this->Conn->qstr($object->GetDBField('Code'));
 				$id = $this->Conn->GetOne($sql);

 				$this->Application->StoreVar('print_certificate_id', $id);

 			}
		}
	}

	/**
	 * Email selected gift certificate
	 *
	 * @param kEvent $event
	 */
	function OnEmailGiftCertificate(&$event)
	{
		$ids = $this->StoreSelectedIDs($event);
		if (!$ids) {
			return ;
		}

		$object =& $event->getObject( Array ('skip_autoload' => true) );
		/* @var $object kDBItem */

		foreach ($ids as $id) {
			$object->Load($id);

			$send_params = Array (
				'from_email' => $this->Application->ConfigValue('Smtp_AdminMailFrom'),
				'from_name' => $object->GetDBField('Purchaser'),
				'to_email' => $object->GetDBField('RecipientEmail'),
				'to_name' => $object->GetDBField('Recipient'),
				'message' => $object->GetDBField('Message'),
				'amount' => $object->GetField('Amount'),
				'gifcert_id' => $object->GetDBField('Code'),
			);

			$this->Application->EmailEventUser('USER.GIFTCERTIFICATE', null, $send_params);
			$this->Application->EmailEventAdmin('USER.GIFTCERTIFICATE', null, $send_params);
		}

		$this->clearSelectedIDs($event);
	}

}