<?php
/**
* @version	$Id: gift_certificates_tp.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class GiftCertificateTagProcessor extends kDBTagProcessor {

	function LastCloneCount($params)
	{
		$clone_count = $this->Application->RecallVar('CoupLastCloneCount');
		if (!$clone_count){
			$clone_count = 1;
		}
		return $clone_count;
	}

	function DefaultExpDate($params)
	{
		$object = &$this->Application->recallObject($this->getPrefixSpecial());
		$formatter =& $this->Application->makeClass('kDateFormatter');
		return $formatter->Format( adodb_mktime() + $this->Application->ConfigValue('Comm_DefaultCouponDuration') * 3600 * 24, 'Expiration_date', $object);
	}

	function DefaultExpTime($params)
	{
		$object = &$this->Application->recallObject($this->getPrefixSpecial());
		$formatter =& $this->Application->makeClass('kDateFormatter');
		return $formatter->Format( adodb_mktime() + $this->Application->ConfigValue('Comm_DefaultCouponDuration') * 3600 * 24, 'Expiration_time', $object);
	}

	function HasOrder($params)
	{
		if ($this->IsNewItem($params)) {
			return 0;
		}

		$object =& $this->getObject($params);

		$sql = 'SELECT COUNT(OrderId)
				FROM '.TABLE_PREFIX.'Orders
				WHERE GiftCertificateId = '.$object->GetID();
		return $this->Conn->GetOne($sql);
	}

	/**
	 * Print link for gift certificate (admin only)
	 *
	 * @param Array $params
	 */
	function PrintLink($params)
	{
		$params[$this->getPrefixSpecial().'_id'] = $this->Application->RecallVar('print_certificate_id');
		$this->Application->RemoveVar('print_certificate_id');

		$main_processor =& $this->Application->recallTagProcessor('m');
		/* @var $main_processor kMainTagProcessor */

		return $main_processor->Link($params);
	}
}