<?php
/**
* @version	$Id: discounts_config.php 13938 2010-09-14 09:12:39Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'd',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'DiscountsEventHandler','file'=>'discounts_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'kDBTagProcessor','file'=>'','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array(),
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),
					'IDField'			=>	'DiscountId',
					'StatusField'		=>	Array('Status'),
					'TitleField'		=>	'Name',
					'TableName'			=>	TABLE_PREFIX.'ProductsDiscounts',
					'SubItems' => Array('di'),

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('d'=>'!la_title_Adding_Discount!'),
																		'edit_status_labels'	=> Array('d'=>'!la_title_Editing_Discount!'),
																		'new_titlefield'		=> Array('d'=>'!la_title_New_Discount!'),
																),

												'discounts_list'=>Array('prefixes'				=>	Array('d_List'),
																		'format'				=>	"!la_title_Discounts!",
																),

												'discount_edit'=>Array(	'prefixes'				=> Array('d'),
																		'format'				=> "#d_status# '#d_titlefield#' - !la_title_General!",
																),

												'discount_items'=>Array('prefixes'				=> Array('d','di_List'),
																		'format'				=> "#d_status# '#d_titlefield#' - !la_title_DiscountItems!",
																),

													),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/discounts/discount_edit', 'priority' => 1),
							'items' => Array ('title' => 'la_tab_DiscountItems', 't' => 'in-commerce/discounts/discount_items', 'priority' => 2),
						),
					),

					'PermSection'		=>	Array('main' => 'in-commerce:discounts'),

					'Sections'			=>	Array(
						'in-commerce:discounts_folder'	=>	Array(
							'parent' => 'in-commerce',
							'use_parent_header' => 1,
							'icon'			=>	'discounts_coupons',
							'label'			=>	'la_tab_DiscountsAndCoupons',
							'permissions'	=>	Array(),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),

						'in-commerce:discounts'	=>	Array(
							'parent'		=>	'in-commerce:discounts_folder',
							'icon'			=>	'discounts_coupons',
							'label'			=>	'la_tab_Discounts',
							'url'			=>	Array('t' => 'in-commerce/discounts/discounts_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	3.1, // <parent_priority>.<own_priority>, because this section replaces parent in tree
							'type'			=>	stTAB,
						),
					),

					'ListSQLs'			=>	Array(	''=>'SELECT %1$s.* %2$s FROM %1$s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %1$s',
																		),

					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields' =>	Array (
					    'DiscountId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
					    'Status' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'default' => 2 ),
					    'Name' => Array('type'=>'string','required' => 1, 'default' => null, 'max_len'=>255),
					    'Start' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
					    'End' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
					    'GroupId' => Array(
					    	'type' => 'int',
					    	'formatter'=>'kOptionsFormatter', 'options_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalGroup WHERE Personal = 0 ORDER BY Name', 'option_key_field'=>'GroupId', 'option_title_field'=>'Name',
					    	'required' => 1, 'default' => NULL
					    ),
					    'Type' => Array(
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (
					    		1 => 'la_Flat', 2 => 'la_Percent'/*, 3 => 'la_FreeShipping'  */
					    	),
					    	'use_phrases' => 1, 'default' => 1,
					    ),
					    'Amount' => Array('type'=>'double', 'default' => null),
					),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array(
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_pending.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'DiscountId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Name' => Array( 'title'=>'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Start' => Array( 'title'=>'la_col_Start', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'End' => Array( 'title'=>'la_col_End', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'GroupId' => Array( 'title'=>'la_col_Group', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
								'Type' => Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 90, ),
								'Status' => Array( 'title'=>'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 90, ),
								'Amount' => Array( 'title'=>'la_col_Amount', 'filter_block' => 'grid_float_range_filter', 'width' => 100, ),
							),
						),
					),
	);