<?php
/**
* @version	$Id: shipping_quote_engines_config.php 13813 2010-07-07 09:44:57Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'sqe',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ShippingQuoteEngineEventHandler', 'file' => 'shipping_quote_engine_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),
					'RegisterClasses'	=>	Array (
												Array ('pseudo' => 'ShippingQuoteEngine', 'class' => 'ShippingQuoteEngine', 'file' => 'shipping_quote_engine.php', 'build_event' => ''),
												Array ('pseudo' => 'CustomShippingQuoteEngine', 'class' => 'CustomShippingQuoteEngine', 'file' => 'custom_shipping_quote_engine.php', 'require_classes' => 'ShippingQuoteEngine', 'build_event' => ''),
												Array ('pseudo' => 'Intershipper', 'class' => 'Intershipper', 'file' => 'intershipper.php', 'require_classes' => 'ShippingQuoteEngine', 'build_event' => ''),
												Array ('pseudo' => 'USPS', 'class' => 'USPS', 'file' => 'usps.php', 'require_classes' => 'ShippingQuoteEngine', 'build_event' => ''),
												Array ('pseudo' => 'ShippingQuoteCollector', 'class' => 'ShippingQuoteCollector', 'file' => 'shipping_quote_collector.php', 'build_event' => '', 'require_classes' => 'ShippingQuoteEngine'),
											),
					'AutoLoad'			=>	true,
					'Hooks'				=>	Array (
											),
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),
					'IDField'			=>	'EngineId',
					'StatusField'		=>	Array ('Status'),
					'TitleField'		=>  'Name',

					'TitlePresets'		=>	Array (
												'default'	=>	Array (	'edit_status_labels'	=> Array ('sqe' => '!la_title_EditingShippingQuoteEngine!'),
																),
												'engine_list' =>Array (		'prefixes'				=> Array ('sqe_List'),
																			'format'				=>	"!la_title_ShippingQuoteEngines!",
																),
												'engine_edit' =>Array (		'prefixes'				=> Array ('sqe'),
																			'format'				=> "#sqe_status# '#sqe_titlefield#' - !la_title_General!",
																),
											),

					'PermSection'		=>	Array ('main' => 'in-commerce:shipping_quote_engines'),

					'Sections'			=>	Array (
						'in-commerce:shipping_quote_engines'	=>	Array (
							'parent'		=>	'in-commerce:shipping_folder',
							'icon'			=>	'conf_shipping',
							'label'			=>	'la_tab_ShippingQuoteEngines',
							'url'			=>	Array ('t' => 'in-commerce/shipping/shipping_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	4.2,
							'type'			=>	stTAB,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'ShippingQuoteEngines',

					'FilterMenu'		=>	Array (
												'Groups' => Array (
													Array ('mode' => 'AND', 'filters' => Array ('show_active', 'show_disabled'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array (
													'show_active'	=>	Array ('label' => 'la_Active', 'on_sql' => '', 'off_sql' => '%1$s.Status != 1' ),
													'show_disabled'	=>	Array ('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Status != 0'  ),
												)
											),

					'ListSQLs'			=>	Array (	'' =>	'SELECT * FROM %s'),
																		 // key - special, value - list select sql
					'ItemSQLs'			=>	Array (	'' =>	'SELECT * FROM %s'),

					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Name' => 'asc'),
																)
															),
					'Fields' => Array (
			            'EngineId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Name' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			            'FlatSurcharge' => Array ('type' => 'double', 'not_null' => 1, 'default' => '0'),
			            'PercentSurcharge' => Array ('type' => 'double', 'not_null' => 1, 'default' => '0'),
			            'Status' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Enabled', 0 => 'la_Disabled'), 'use_phrases' => 1,
			            	'error_msgs' => Array (
			            		'curl_not_present' => '!la_error_EnableCurlFirst!',
			            		'from_info_not_filled_in' => '!la_error_FillInShippingFromAddress!',
			            	),
			            	'default' => 0, 'not_null' => 1,
						),
			            'Properties' => Array ('type' => 'string', 'default' => NULL),
			            'ClassName' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			        ),

					'VirtualFields' => Array (
						'AccountLogin'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'AccountPassword'	=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'UPSEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'UPSAccount'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'UPSInvoiced'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Invoiced', 0 => 'NotInvoiced'),
			        	),
						'FDXEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'FDXAccount'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'FDXInvoiced'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Invoiced', 0 => 'NotInvoiced'),
			        	),
						'DHLEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'DHLAccount'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'DHLInvoiced'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Invoiced', 0 => 'NotInvoiced'),
			        	),
						'USPEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'USPAccount'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'USPInvoiced'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Invoiced', 0 => 'NotInvoiced'),
			        	),
						'ARBEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'ARBAccount'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'ARBInvoiced'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Invoiced', 0 => 'NotInvoiced'),
			        	),
						'1DYEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'2DYEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'3DYEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'GNDEnabled'		=>	Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'Enabled', 0 => 'Disabled'),
			        	),
						'ShipMethod'		=>	Array (
							'type' => 'string',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (
								'DRP' => 'Drop-Off At Carrier Location',
								'PCK' => 'Schedule A Special Pickup',
								'SCD' => 'Regularly Scheduled Pickup'),
			        	),
					),
					'Grids'	=> Array (
						'Default' =>	Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'EngineId' => Array ( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'Name' => Array ( 'title' => 'la_col_ShippingQuoteEngineName', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'FlatSurcharge' => Array ( 'title' => 'la_col_FlatSurcharge', 'filter_block' => 'grid_float_range_filter', 'width' => 150, ),
								'PercentSurcharge' => Array ( 'title' => 'la_col_PercentSurcharge', 'filter_block' => 'grid_float_range_filter', 'width' => 150, ),
								'Status' => Array ( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
							),
						),
					),
	);