<?php
/**
* @version	$Id: google_checkout_notify.php 13704 2010-06-09 14:52:56Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	define('FULL_PATH', realpath(dirname(__FILE__) . '/../../../../../..'));
	define('REL_PATH', 'modules/in-commerce/units/gateways/gw_classes/notify_scripts');
	define('ADMIN', 1);
	include_once(FULL_PATH.'/core/kernel/startup.php');

	$application =& kApplication::Instance();
	$application->Init();

	$sql = 'SELECT PaymentTypeId FROM '.TABLE_PREFIX.'PaymentTypes AS pt
			LEFT JOIN '.TABLE_PREFIX.'Gateways AS g ON g.GatewayId = pt.GatewayId
			WHERE g.ClassName = "kGWGoogleCheckout"';
	$payment_type_id = $application->Conn->GetOne($sql);

	$application->SetVar('payment_type_id', $payment_type_id); // keep, because kGWGoogleCheckout::processNewOrderNotification relies on this

	$order =& $application->recallObject('ord', null, Array ('skip_autoload' => true));
	/* @var $order OrdersItem */

	$gw_data = $order->getGatewayData($application->GetVar('payment_type_id'));
	$application->registerClass( $gw_data['ClassName'], GW_CLASS_PATH.'/'.$gw_data['ClassFile'] );
	$gateway_object =& $application->recallObject( $gw_data['ClassName'] );

	$transaction_status = $gateway_object->processNotification($gw_data['gw_params']);

	$sql = 'UPDATE '.$order->TableName.'
			SET TransactionStatus = '.$transaction_status.'
			WHERE '.$order->IDField.' = '.$order->GetID();
	$application->Conn->Query($sql);

	$order->SetDBField('TransactionStatus', $transaction_status);

	if ($transaction_status == 1) {
		$dummy_var = '10';
		$application->SetVar('ord_id', $order->GetID()); // used in OrdersEventHandler::UpdateOrderItem
		$application->HandleEvent($dummy_var, 'ord:OnCompleteOrder');
	}

	$application->Done();