<?php
/**
* @version	$Id: shipping_quote_engine_event_handler.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ShippingQuoteEngineEventHandler extends kDBEventHandler {

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnBeforeItemUpdate(&$event)
	{
		$object =& $event->getObject();
		if($object->GetDBField('AccountPassword') == '')
		{
			$sql = 'SELECT Properties FROM '.$object->TableName.'
					WHERE EngineId = '.$object->GetDBField('EngineId');
			$properties = unserialize( $this->Conn->GetOne($sql) );
			$object->SetDBField('AccountPassword', $properties['AccountPassword']);
		}
		$properties = Array(
							'AccountLogin'		=>	$object->GetDBField('AccountLogin'),
							'AccountPassword'	=>	$object->GetDBField('AccountPassword'),
							'UPSEnabled'		=>	$object->GetDBField('UPSEnabled'),
							'UPSAccount'		=>	$object->GetDBField('UPSAccount'),
							'UPSInvoiced'		=>	$object->GetDBField('UPSInvoiced'),
							'FDXEnabled'		=>	$object->GetDBField('FDXEnabled'),
							'FDXAccount'		=>	$object->GetDBField('FDXAccount'),
							'DHLEnabled'		=>	$object->GetDBField('DHLEnabled'),
							'DHLAccount'		=>	$object->GetDBField('DHLAccount'),
							'DHLInvoiced'		=>	$object->GetDBField('DHLInvoiced'),
							'USPEnabled'		=>	$object->GetDBField('USPEnabled'),
							'USPAccount'		=>	$object->GetDBField('USPAccount'),
							'USPInvoiced'		=>	$object->GetDBField('USPInvoiced'),
							'ARBEnabled'		=>	$object->GetDBField('ARBEnabled'),
							'ARBAccount'		=>	$object->GetDBField('ARBAccount'),
							'ARBInvoiced'		=>	$object->GetDBField('ARBInvoiced'),
							'1DYEnabled'		=>	$object->GetDBField('1DYEnabled'),
							'2DYEnabled'		=>	$object->GetDBField('2DYEnabled'),
							'3DYEnabled'		=>	$object->GetDBField('3DYEnabled'),
							'GNDEnabled'		=>	$object->GetDBField('GNDEnabled'),
							'ShipMethod'		=>	$object->GetDBField('ShipMethod'),
							);
		$properties = serialize($properties);
		$object->SetDBField('Properties', $properties);

		$from_country = $this->Application->ConfigValue('Comm_Shipping_Country');
		if( mb_strlen($from_country) == 3)
		{
			$sql = 'SELECT DestAbbr2 FROM '.TABLE_PREFIX.'StdDestinations WHERE DestAbbr = "'.$from_country.'"';
			$from_country = $this->Conn->GetOne($sql);
		}
		if( !function_exists('curl_init') )
		{
			$object->FieldErrors['Status']['pseudo'] = 'curl_not_present';
			$object->ErrorMsgs['curl_not_present'] = $this->Application->Phrase('la_error_EnableCurlFirst');
		}
		elseif( $object->GetDBField('Status') == 1 && (!$this->Application->ConfigValue('Comm_Shipping_City') || !$from_country ||
			( ($from_country == 'US' || $from_country == 'CA') && !$this->Application->ConfigValue('Comm_Shipping_State') ) ||
			!$this->Application->ConfigValue('Comm_Shipping_ZIP') ) )
		{
			$object->FieldErrors['Status']['pseudo'] = 'from_info_not_filled_in';
			$object->ErrorMsgs['from_info_not_filled_in'] = $this->Application->Phrase('la_error_FillInShippingFromAddress');
		}

	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function iterateItems(&$event)
	{
//		$event->setEventParam('SkipProcessing', 1);
		parent::iterateItems($event);
		if($event->Name == 'OnMassApprove')
		{
			$event->status = erSUCCESS;
			$event->redirect = true;
		}
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnAfterItemLoad(&$event)
	{
		$object =& $event->getObject();
		$properties = unserialize( $object->GetDBField('Properties') );
		$object->SetDBFieldsFromHash($properties);
	}

	function OnAfterItemCreate(&$event)
	{
		$event->CallSubEvent('OnAnyChange');
	}

	function OnAfterItemUpdate(&$event)
	{
		$event->CallSubEvent('OnAnyChange');
	}

	function OnAfterItemDelete(&$event)
	{
		$event->CallSubEvent('OnAnyChange');
	}

	function OnAnyChange(&$event)
	{
		$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Cache WHERE VarName LIKE "ShippingQuotes%"';
		$this->Conn->Query($sql);
	}
}