<?php
/**
* @version	$Id: affiliate_payment_types_config.php 13549 2010-05-11 21:03:39Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'apt',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'AffiliatePaymentTypesEventHandler', 'file' => 'affiliate_payment_types_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'AggregateTags' => Array (
															Array (
																'AggregateTo' => 'u',
																'AggregatedTagName' => 'ListAffiliatesPaymentTypes',
																'LocalTagName' => 'PrintList',
																'LocalSpecial' => 'active',
															),
													),
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'IDField'			=>	'PaymentTypeId',
					'StatusField'		=>	Array ('Status', 'IsPrimary'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'Name',
					'TitlePresets'		=>	Array (
												'default'	=>	Array (	'new_status_labels'		=> Array ('apt' => '!la_title_Adding_Affiliate_Payment_Type!'),
																		'edit_status_labels'	=> Array ('apt' => '!la_title_Editing_Affiliate_Payment_Type!'),
																		'new_titlefield'		=> Array ('apt' => '!la_title_New_Affiliate_Payment_Type!'),
																),

												'affiliate_payment_types_list'	=>	Array ('prefixes' => Array ('apt_List'), 'format' => "!la_title_AffiliatePaymentTypes!"),
												'affiliate_payment_types_edit' => Array ('prefixes' => Array ('apt'), 'format' => "#apt_status# '#apt_titlefield#' - !la_title_General!"),

											),

					'PermSection'		=>	Array ('main' => 'in-commerce:affiliate_payment_types'),

					'Sections'			=>	Array (
							'in-commerce:affiliate_payment_types'	=>	Array (
								'parent'		=>	'in-commerce:affiliates_folder',
								'icon'			=>	'affiliates',
								'label'			=>	'la_tab_AffiliatePaymentTypes',
								'url'			=>	Array ('t' => 'in-commerce/affiliate_plans/affiliate_payment_types_list', 'pass' => 'm'),
								'permissions'	=>	Array (
									'view', 'add', 'edit', 'delete', 'advanced:approve',
									'advanced:decline', 'advanced:set_primary', 'advanced:move_up', 'advanced:move_down'
								),
								'priority'		=>	5.3, // <parent_priority>.<own_priority>, because this section replaces parent in tree
								'type'			=>	stTAB,
							),
					),

					'TableName'			=>	TABLE_PREFIX.'AffiliatePaymentTypes',

					'ListSQLs'			=>	Array ('' => 'SELECT * FROM %s'),
					'ItemSQLs'			=>	Array ('' => 'SELECT * FROM %s'),

					'ListSortings'	=> 	Array (
												'' => Array (
															'ForcedSorting' => Array ('IsPrimary' => 'desc', 'Priority' => 'desc'),
															'Sorting' => Array ('Name' => 'asc'),
														)
										),

					'Fields' => Array (
			            'PaymentTypeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Name' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
			            'Description' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
			            'Status' => Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter', 
			            	'options' => Array ( 0 => 'la_Disabled', 1 => 'la_Active', ), 'use_phrases' => 1,							
							'not_null' => 1, 'default' => 0, 
						),
			            'IsPrimary' => Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter', 
			            	'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,							
							'not_null' => 1, 'default' => 0,
						),
			            'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
					),

					'Grids'	=> Array (
								'Default'		=>	Array (
									'Icons' => Array (
										'default' => 'icon16_item.png',
										'0_0' => 'icon16_disabled.png',
										'0_1' => 'icon16_disabled.png',
										'1_0' => 'icon16_item.png',
										'1_1' => 'icon16_primary.png',
										'module' => 'core',
									),
															'Fields' => Array (
																			'PaymentTypeId' 	=> Array ( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
																			'Name'				=> Array ( 'title' => 'la_col_Name', 'data_block' => 'affiliate_payment_type_caption_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
																			'Description'		=> Array ( 'title' => 'la_col_Description', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
																		),
													),

								),
	);