<?php
/**
* @version	$Id: coupons_config.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'coup',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'CouponsEventHandler','file'=>'coupons_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'CouponsTagProcessor','file'=>'coupons_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'	=>	Array(
												Array(
													'Mode' => hBEFORE,
													'Conditional' => false,
													'HookToPrefix' => 'ord',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnUpdateCart', 'OnCheckout' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnApplyCoupon',
												),
											),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4 =>	'mode', // 't' for temp '' for normal
											),
					'IDField'			=>	'CouponId',
					'StatusField'		=>	Array('Status'),
					'TitleField'		=>	'Name',
					'TableName'			=>	TABLE_PREFIX.'ProductsCoupons',
					'SubItems' => Array('coupi'),

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('coup'=>'!la_title_Adding_Coupon!'),
																		'edit_status_labels'	=> Array('coup'=>'!la_title_Editing_Coupon!'),
																		'new_titlefield'		=> Array('coup'=>'!la_title_New_Coupon!'),
																),

												'coupons_list'=>Array('prefixes'				=>	Array('coup_List'),
																		'format'				=>	"!la_title_Coupons!",
																),

												'coupons_edit'=>Array(	'prefixes'				=> Array('coup'),
																		'format'				=> "#coup_status# '#coup_titlefield#' - !la_title_General!",
																),

												'coupons_items'=>Array('prefixes'				=> Array('coup','coupi_List'),
																		'format'				=> "#coup_status# '#coup_titlefield#' - !la_title_CouponItems!",
																),
												'coupons_clone'=>Array('prefixes'				=> Array('coup'),
																		'format'				=> "!la_CloneCoupon!",
																),

												'coupon_selector' => Array('format' => '!la_title_CouponSelector!'),

													),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/discounts/coupon_edit', 'priority' => 1),
							'items' => Array ('title' => 'la_tab_CouponsItems', 't' => 'in-commerce/discounts/coupon_items', 'priority' => 2),
						),
					),

					'PermSection'		=>	Array('main' => 'in-commerce:coupons'),

					'Sections'			=>	Array(
													'in-commerce:coupons'	=>	Array(
																						'parent'		=>	'in-commerce:discounts_folder',
																						'icon'			=>	'discounts_coupons',
																						'label'			=>	'la_tab_Coupons',
																						'url'			=>	Array('t' => 'in-commerce/discounts/coupons_list', 'pass' => 'm'),
																						'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
																						'priority'		=>	3.2, // <parent_priority>.<own_priority>, because this section replaces parent in tree
																						'type'			=>	stTAB,
																				),
											),

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array(0,1,2), 'type' => WHERE_FILTER),
													Array('mode' => 'AND', 'filters' => Array(4,5/*,6*/), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													0	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => 'Status != 1' ),
													1	=>	Array('label' => 'la_Used', 'on_sql' => '', 'off_sql' => 'Status != 2'  ),
													2	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => 'Status != 0'  ),
													3	=>	Array(),
													4	=>	Array('label' => 'la_Flat', 'on_sql' => '', 'off_sql' => 'Type != 1'  ),
													5	=>	Array('label' => 'la_Percent', 'on_sql' => '', 'off_sql' => 'Type != 2'  ),
												//	6	=>	Array('label' => 'la_FreeShipping', 'on_sql' => '', 'off_sql' => 'Type != 3'  ),
												)
											),

					'ListSQLs'			=>	Array(	''=>'SELECT %1$s.* %2$s FROM %1$s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %1$s',
																		),

					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields'			=>	Array(
											    'CouponId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
											    'Status' => Array (
											    		'type' => 'int', 'formatter' => 'kOptionsFormatter',
											    		'options' => Array ( 1 => 'la_Enabled', 2 => 'la_Used', 0 => 'la_Disabled' ),
											    		'use_phrases' => 1, 'not_null' => 1, 'default' => 1
											    ),
											    'Name' => Array ( 'type' =>'string', 'required' => 1, 'default' => null, 'max_len' => 255),
											    'Code' => Array (
											    		'type' => 'string', 'required' => 1, 'default' => null,
											    		'max_len' => 255, 'unique' => Array ('Code'),
											    ),
											    'Expiration' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null,),
											    'GroupId' => Array ('type' => 'int', 'default' => null, ),
											    'Type' => Array (
											    		'type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
											    		'options' => Array ( 1 => 'la_Flat', 2 => 'la_Percent'/*, 3 => 'la_FreeShipping'*/),
											    		'not_null' => 1, 'default' => 1,
											     ),
											    'Amount' => Array ('type' => 'double', 'default' => null),
											    'LastUsedBy' => Array (
											    	'type' => 'int', 'formatter' => 'kLEFTFormatter',
											    	'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
											    	'options' => Array (-1 => 'root', -2 => 'Guest'),
											    	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PortalUser
											    						WHERE `%s` = \'%s\'','left_key_field'=>'PortalUserId',
											    	'left_title_field' => 'Login', 'required' => 0, 'default' => null,
											    ),
											  	'LastUsedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
											  	'NumberOfUses' => Array ('type' => 'int', 'default' => 1),
											),

					'Grids'	=> Array(
								'Default'		=>	Array(
									'Icons' => Array(
										'default' => 'icon16_item.png',
										0 => 'icon16_disabled.png',
										1 => 'icon16_item.png',
										2 => 'icon16_pending.png',
										'module' => 'core',
									),
															'Fields' => Array(
																		'CouponId'	=> Array ('title'=>'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
																		'Name' => Array( 'title'=>'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
																		'Code' => Array( 'title'=>'la_col_CouponCode', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
																		'Expiration' => Array( 'title'=>'la_col_Expiration', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
																		'Type' => Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
																		'Amount' => Array( 'title'=>'la_col_Amount', 'filter_block' => 'grid_float_range_filter', 'width' => 100, ),
																		'LastUsedBy' => Array('title'=>'la_col_LastUsedBy', 'filter_block' => 'grid_like_filter', 'width' => 140, ),
																		'LastUsedOn' => Array('title'=>'la_col_LastUsedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
																		'NumberOfUses' => Array('title'=>'la_col_NumberOfUses', 'filter_block' => 'grid_range_filter', 'width' => 130, ),
																		),
													),
								'Radio'		=>	Array(
									'Icons' => Array(
										'default' => 'icon16_item.png',
										0 => 'icon16_disabled.png',
										1 => 'icon16_item.png',
										2 => 'icon16_pending.png',
										'module' => 'core',
									),
														'Fields' => Array(
																		'CouponId'	=> Array ('title'=>'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
																		'Name' => Array( 'title'=>'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
																		'Code' => Array( 'title'=>'la_col_CouponCode', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
																		'Expiration' => Array( 'title'=>'la_col_Expiration', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
																		'Type' => Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
																		'Amount' => Array( 'title'=>'la_col_Amount', 'filter_block' => 'grid_float_range_filter', 'width' => 100, ),
																		'LastUsedBy' => Array('title'=>'la_col_LastUsedBy', 'filter_block' => 'grid_like_filter', 'width' => 140, ),
																		'LastUsedOn' => Array('title'=>'la_col_LastUsedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
																		'NumberOfUses' => Array('title'=>'la_col_NumberOfUses', 'filter_block' => 'grid_range_filter', 'width' => 130, ),
																	),
												),
								),
	);