<!--##
<NAME>Affiliate</NAME>
<DESC>Affiliate page</DESC>
<SECTION>My Account||Store||Affiliates</SECTION>
##-->

<inp2:m_RequireLogin login_template="platform/login/register"/> <!--## LOGIN REQUIRED ##-->
<inp2:m_CheckSSL mode="required" condition="Require_SSL" /> <!--## CHECK IF SSL REQUIRED ##-->

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:m_Phrase label="lu_title_Affiliate"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/cart_indicator.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_if check="u_IsAffiliate">
				<inp2:m_RenderElement name="in-commerce/elements/side_boxes/affiliate_navigation.elm" design="blue_box"/>
			</inp2:m_if>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/top_seller_products.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/recent_products.elm" design="blue_box" data_exists="1"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## /SIDE-BAR ELEMENT ##-->

<!--## MAIN CONTENT ##-->
<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="lu_title_MyAccount,lu_title_Affiliate" templates="platform/my_account/my_account,in-commerce/my_account/affiliate/affiliate"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">

				<inp2:m_DefineElement name="affiliate_element">
					<a href="<inp2:m_Link template="$template"/>">
					<strong><inp2:m_Phrase label="$label"/></strong></a><br />
					<inp2:m_Phrase label="$text"/><br /><br />
				</inp2:m_DefineElement>

				<inp2:m_if check="u_IsAffiliate">
				<!-- Affiliate Section List -->
					<inp2:m_Capture to_var="header">
						<inp2:m_Phrase label="lu_title_Affiliate"/>
					</inp2:m_Capture>

					<inp2:m_if check="u_AffiliateIsNotActive">
						<table class="warning-message fullwidth">
							<tr>
								<td width="30">
									<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/warning_icon.gif" width="21" height="18" alt=""/>
								</td>
								<td><inp2:m_phrase name="lu_Warning"/></td>
							</tr>
						</table>
						<br />
						<inp2:m_Phrase label="lu_AffiliateIsPendingOrDisabled"/><br /><br />
					</inp2:m_if>

					<inp2:m_RenderElement name="affiliate_element" template="in-commerce/my_account/affiliate/affiliate_statistics" label="lu_comm_AffiliateStatistics" text="lu_AffiliateStatisticsText"/>
					<inp2:m_RenderElement name="affiliate_element" template="in-commerce/my_account/affiliate/affiliate_payments" label="lu_AffiliatePayments" text="lu_AffiliatePaymentsText"/>
					<inp2:m_RenderElement name="affiliate_element" template="in-commerce/my_account/affiliate/affiliate_materials" label="lu_AffiliateMaterials" text="lu_AffiliateMaterialsText"/>
					<inp2:m_RenderElement name="affiliate_element" template="in-commerce/my_account/affiliate/affiliate_payment_type" label="lu_ChangePaymentType" text="lu_ChangePaymentTypeText"/>

					<a href="<inp2:m_Link t='in-commerce/my_account/affiliate'/>" onclick="showAffiliateAgreement();return false;">
					<strong><inp2:m_Phrase label="lu_TermsAndConditionsLink"/></strong></a><br />
					<inp2:m_Phrase label="lu_TermsAndConditionsText"/><br /><br />
				<!-- End Of Affiliate Section List -->
				<inp2:m_else />
				<!-- Affiliate Registration -->
					<inp2:m_Capture to_var="header">
						<inp2:m_Phrase label="lu_title_AffiliateRegistration"/>
					</inp2:m_Capture>

					<inp2:m_Phrase label="lu_BecomeAnAffiliateDescription"/><br /><br />

					<inp2:m_if check="u_HasError" field="any">
						<inp2:m_RenderElement name="error_message" />
					</inp2:m_if>

					<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/grey_pix.gif" width="100%" height="1" align="absmiddle" alt="" /><br />
					<br />
					<inp2:m_include template="in-commerce/elements/forms.elm"/>
					<form method="post" action="<inp2:m_FormAction/>">
						<table border="0" class="form-data fullwidth">
							<inp2:m_RenderElement name="inp_affiliate_box" field="SSN" title="lu_fld_SSNField" style="width:155px" required="1"/>
							<inp2:m_RenderElement name="inp_affiliate_payment_types" field="PaymentTypeId" title="lu_fld_AffiliatePaymentType" style="width:155px"/>
							<inp2:m_RenderElement name="inp_affiliate_textarea" field="Comments" title="lu_fld_AffiliateComments" cols="35" rows="5" style="width:155px"/>
							<inp2:m_RenderElement name="inp_affiliate_terms_checkbox"/>

							<inp2:m_RenderElement design="inp_edit_buttons">
								<input type="hidden" name="next_template" value="in-commerce/my_account/affiliate/affiliate_thankyou" />
								<input type="submit" class="button" name="events[affil][OnBecomeAffiliate]" id="events[affil][OnBecomeAffiliate]" value="<inp2:m_Phrase label="lu_comm_BecomeAnAffiliate" no_editing="1"/>" />
							</inp2:m_RenderElement>
						</table>
					</form>
				</inp2:m_if>
			</inp2:m_RenderElement>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## //MAIN CONTENT ##-->

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>