<?php
/**
* @version	$Id: prerequisites.php 12739 2009-10-20 19:38:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	$prerequisite_class = 'InCommercePrerequisites';

	/**
	 * Class, that holds all prerequisite scripts for "In-Commerce" module
	 *
	 */
	class InCommercePrerequisites extends kHelper {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Checks minimal version, that could be upgradeable
		 *
		 * @param string $mode when called mode {install, standalone, upgrade)
		 */
		function CheckPrerequisites($versions, $mode)
		{
			$errors = Array ();

			if ($mode == 'standalone') {
				if (!$this->Application->isModuleEnabled('In-Portal')) {
					$errors[] = 'Please install or enable "In-Portal" module first';
				}
			}

			if ($mode == 'upgrade') {
				$sql = 'SELECT Version
						FROM ' . TABLE_PREFIX . 'Modules
						WHERE Name = "In-Portal"';
				$inportal_version = $this->Conn->GetOne($sql);

				if ($inportal_version === false) {
					// only, when In-Portal was installed
					return $errors;
				}

				$min_version = '4.3.1';

				$current_version = $this->_toolkit->ConvertModuleVersion($inportal_version);
				$needed_version = $this->_toolkit->ConvertModuleVersion($min_version);
				if ($current_version < $needed_version) {
					$errors[] = 'Please upgrade "In-Portal" to version ' . $min_version;
				}
			}

			return $errors;
		}
	}

?>