<?php
/**
* @version	$Id: taxes_event_handler.php 12303 2009-08-17 01:54:03Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class TaxesEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
								'OnTypeChange'		=>	Array('self' => 'add|edit'),
								'OnCountryChange'	=>	Array('self' => 'add|edit'),
						);
		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	function mapEvents()
	{
		parent::mapEvents();	// ensure auto-adding of approve/decine and so on events
		$zones_events = Array(		'OnAddLocation'		=>	'DestinationAction',
									'OnRemoveLocation'	=>	'DestinationAction',
									'OnLoadZoneForm'	=>	'DestinationAction',
									/*'OnCountryChange'	=>	'DestinationAction',*/
									'OnNew'				=>	'DestinationAction');

		$this->eventMethods = array_merge($this->eventMethods, $zones_events);
	}

	function customProcessing(&$event, $type)
	{
		$zone_object =& $event->GetObject();
		switch($type)
		{
			case 'before':

				break;
			case 'after':
				$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
				$dst_object =& $this->Application->RecallObject('taxdst');
				if ($event->Name == 'OnUpdate')
				{
					$sql = 'DELETE FROM '.$dst_object->TableName.' WHERE TaxZoneId='.$zone_object->GetID();
					$this->Conn->Query($sql);
				}
				else
				{
					$temp = $this->Application->GetVar('taxdst');
					foreach ($temp as $key => $value)
					{
						$temp[$key]['TaxZoneId'] = $zone_object->GetID();
					}
					$this->Application->SetVar('taxdst', $temp);
				}

				$dst_event = new kEvent();
				$dst_event->Init('taxdst');
				$dst_event->Name = 'OnCreate';
				$this->Application->HandleEvent($dst_event);
				break;

			default:
		}
	}

/*	function OnItemBuild(&$event)
	{
		parent::OnItemBuild($event);
		$object = $event->GetObject();
		$object->SetDBField('ZoneID', $this->Application->GetVar('zone_id') );
		$object->ID = $this->Application->GetVar('zone_id');
	}*/

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnTypeChange(&$event)
	{
		$this->Application->DeleteVar('taxdst');
		$event->CallSubEvent('OnPreSave');
		$event->redirect = false;
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function DestinationAction(&$event)
	{
		$event->redirect = false;

		$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
		if($items_info)
		{
			foreach($items_info as $item_id => $field_values)
			{
				// this is to receive $item_id
			}
		}

		$object =& $event->getObject( Array('skip_autoload' => true) );
		$object->Load($item_id);

		$object->SetFieldsFromHash($field_values);
		$object->SetDBField('TaxZoneID', $item_id);

		$destination =& $this->Application->recallObject('taxdst');
		$tax_object =& $this->Application->recallObject('tax');

		switch($event->Name)
		{
			case 'OnAddLocation':

				$temp = $this->Application->GetVar('taxdst');
				$zip = $this->Application->GetVar('zip_input') ? $this->Application->GetVar('zip_input') : $this->Application->GetVar('zip_dropdown');
				$exist=0;

				switch ($object->GetDBField('Type'))
				{
					case 1:
						$location_id = $this->Application->GetVar('country');
						break;
					case 2:
						$location_id = $this->Application->GetVar('state');
						break;
					default:
						$location_id = $this->Application->GetVar('StatesCountry');
						foreach($temp as $temp_id => $temp_val){
							if ($temp_val['DestValue']==$zip){
								$exist=1;
								break;
							}
						}
				}

				if ($exist == 0){
					$new_id = (int)$this->Conn->GetOne('SELECT MIN('.$destination->IDField.') FROM '.$destination->TableName);

					if($new_id > 0) $new_id = 0;
					do
					{
						$new_id--;
					} while ($this->check_array($this->Application->GetVar('taxdst'), 'TaxZoneDestId', $new_id));




					if( ($location_id && !$this->check_array($temp, 'StdDestId', $location_id)) ||
							($zip && !$this->check_array($temp, 'DestValue', $zip)) )
					{

						if($tax_object->GetDBField('Type') == 3 && $zip ==''){
							continue;
						}

						$temp[$new_id]['TaxZoneDestId'] = $new_id;
						$temp[$new_id]['StdDestId'] = $location_id;
						$temp[$new_id]['DestValue'] = $zip ? $zip : '';

						$this->Application->SetVar('taxdst', $temp);
					}
				}
				break;

			case 'OnRemoveLocation':

				$temp = $this->Application->GetVar('taxdst');
				$selected_destinations = explode(',', $this->Application->GetVar('selected_destinations'));
				foreach ($selected_destinations as $dest)
				{
					unset( $temp[$dest] );
					if (strlen($dest)>0){
						$sql = 'DELETE FROM '.$destination->TableName.' WHERE TaxZoneDestId ='.$dest;
						$this->Conn->Query($sql);
					}
				}
				$this->Application->SetVar('taxdst', $temp);

				break;

			case 'OnLoadZoneForm':

				$sql = 'SELECT * FROM '.$destination->TableName.' WHERE TaxZoneId='.$item_id;
				$res = $this->Conn->Query($sql);
				$temp = Array();
				foreach ($res as $dest_record)
				{
					$temp[$dest_record['TaxZoneDestId']]['TaxZoneDestId'] = $dest_record['TaxZoneDestId'];
					$temp[$dest_record['TaxZoneDestId']]['StdDestId'] = $dest_record['StdDestId'];
					$temp[$dest_record['TaxZoneDestId']]['DestValue'] = $dest_record['DestValue'];
				}
				$this->Application->SetVar('taxdst', $temp);
				//$object =& $event->getObject();
				//$object->SetDBField('ShippingTypeID', $this->Application->GetVar('s_id'));

				break;

			case 'OnNew':

				//$object =& $event->getObject();
				//$object->SetDBField('ShippingTypeID', $this->Application->GetVar('s_id'));
				break;

			case 'OnCountryChange':

				$this->Application->DeleteVar('taxdst');

				break;

			default:
		}
		/*if($this->Application->GetVar('tax_OriginalSaveEvent'))
		{
			$this->Application->SetVar($event->Prefix_Special.'_SaveEvent', $this->Application->GetVar('tax_OriginalSaveEvent'));
		}*/


		$event->CallSubEvent("OnPreSave");
/*
			$child_event = new kEvent();
			$child_event->Prefix = "tax";
			$child_event->Special = "";
			$child_event->Prefix_Special = "tax";
			$child_event->redirect = false;
			$child_event->Name = "OnPreSave";

			$this->Application->HandleEvent( $child_event);		*/

	}

	function OnMassDelete(&$event)
	{
		$this->StoreSelectedIDs($event);

		$event->setEventParam('ids', $this->getSelectedIDs($event) );
		$this->customProcessing($event, 'before');
		$ids = $event->getEventParam('ids');
		$ids = implode(',', $ids);

		$dst =& $this->Application->recallObject('taxdst');
		$sql = 'DELETE FROM '.$dst->TableName.' WHERE TaxZoneId IN ('.$ids.')';
		$this->Conn->Query($sql);

		parent::OnMassDelete($event);
	}

	function OnCountryChange(&$event)
	{
		$destinations = &$this->Application->recallObject('taxdst');

		$queryDel="DELETE FROM ".$destinations->TableName." WHERE TaxZoneId=".(int)$this->Application->GetVar('tax_id');
		$this->Conn->Query($queryDel);

		$this->Application->DeleteVar('taxdst');
		$event->CallSubEvent('OnPreSave');
		$event->redirect = false;
	}

}