<?php
/**
* @version	$Id: gw_event_handler.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

class GatewayEventHandler extends kDBEventHandler {

	function OnSaveValues(&$event)
	{
		// if there is no id - it means we need to create an item
		$item_id = $this->getPassedID($event);
		$event->setPseudoClass('_List');

		$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
		$PaymentType_info = $this->Application->GetVar( 'pt' );
		$GWConfigValue =& $this->Application->recallObject('gwfv');
		$GWConfigValue->SetDBField('PaymentTypeId', $this->Application->GetVar('pt_id'));

		//deleting old values
		$sql = 'DELETE FROM '.$GWConfigValue->TableName.' WHERE PaymentTypeId = '.$this->Application->GetVar('pt_id');
		$res = $this->Conn->Query($sql);

		//selecting fields for selected gateway only
		$sql = 'SELECT GWConfigFieldId FROM '.TABLE_PREFIX.'GatewayConfigFields
					WHERE GatewayId = '.$PaymentType_info[$this->Application->GetVar('pt_id')]['GatewayId'];
		$res = $this->Conn->GetCol($sql);

		if($items_info)
		{
			foreach($res as $gw_field_id)
			{
				$field_values = $items_info[$gw_field_id];
				$field_values['GWConfigFieldId'] = $gw_field_id;

				$GWConfigValue->SetFieldsFromHash($field_values);
				if( $GWConfigValue->Create() )
				{
					$event->status=erSUCCESS;
				}
				else
				{
					$event->status=erFAIL;
					break;
				}
			}
		}
	}

	function OnCheckGateways(&$event)
	{
		if (!$this->Application->IsAdmin()) return ;
		$fh=opendir(GW_CLASS_PATH);
		while( $entry=readdir($fh) )
		{
			if ( !is_file(GW_CLASS_PATH.'/'.$entry) ) continue;
			$pathinfo = pathinfo($entry);
			if ( $pathinfo['extension'] != 'php') continue;

			$class_name = false;
			include_once(GW_CLASS_PATH.'/'.$entry);
			if (!$class_name) continue;
			$tmp = new $class_name();
			$tmp->Install();
		}

	}
}

?>