<?php
/**
* @version	$Id: currencies_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'curr',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'CurrenciesEventHandler','file'=>'currencies_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'CurrenciesTagProcessor','file'=>'currencies_tag_processor.php','build_event'=>'OnBuild'),
					'RegisterClasses'	=>	Array(
												Array('pseudo'=>'BankLVCurrencyRates','class'=>'kBankLVCurrencyRates','file'=>'currency_rates.php','build_event'=>''),
												Array('pseudo'=>'ECBCurrencyRates','class'=>'kECBCurrencyRates','file'=>'currency_rates.php','build_event'=>''),
												Array('pseudo'=>'FRNYCurrencyRates','class'=>'kFRNYCurrencyRates','file'=>'currency_rates.php','build_event'=>''),
											),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array(),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4	=>	'mode',
											),

					/*'Hooks'				=>	Array(
							Array(
								'Mode' => hBEFORE,
								'Conditional' => true,
								'HookToPrefix' => 'tax',
								'HookToSpecial' => '',
								'HookToEvent' => Array( 'onEdit' ),
								'DoPrefix' => '',
								'DoSpecial' => '',
								'DoEvent' => 'OnLoadZoneForm',
							),
						),*/
					'IDField' 			=>	'CurrencyId',
					'StatusField'		=>	Array('Status', 'IsPrimary'),
					'TitleField'		=>  'ISO',
					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('curr'=>'!la_title_AddingCurrency!'),
																		'edit_status_labels'	=> Array('curr'=>'!la_title_EditingCurrency!'),
																		'new_titlefield'		=> Array('curr'=>'!la_title_NewCurrency!'),
																),
												'currencies_list'=>Array(	'prefixes'				=> Array('curr_List'),
																			'format'				=>	"!la_title_Currencies!",
																),
												'currencies_edit'=>Array(	'prefixes'				=> Array('curr'),
																			'new_titlefield'		=> Array('curr'=>'!la_title_NewCurrency!'),
																			'format'				=> "#curr_status# '#curr_titlefield#' - !la_title_General!",
																),
											),

					'PermSection'		=>	Array('main' => 'in-commerce:currencies'),

					'Sections'			=>	Array(
						'in-commerce:currencies'	=>	Array(
							'parent'		=>	'in-commerce:setting_folder',
							'icon'			=>	'currencies',
							'label'			=>	'la_tab_Currencies',
							'url'			=>	Array('t' => 'in-commerce/currencies/currencies_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:move_up', 'advanced:move_down', 'advanced:update_rate', 'advanced:set_primary'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Currencies',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'SubItems' =>	Array(),

					'ListSQLs'			=>	Array(	''=>	'SELECT %1$s.*,
															phr.Translation
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Phrase phr ON
															%1$s.Name = phr.Phrase'),
																		 // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>	'SELECT * FROM %s'),

					'CalculatedFields'	=>	Array(
												''	=>	Array(
															'Translation'	=>	'phr.Translation',
														),
											),

					'ListSortings'	=> 	Array(
												'' => Array(
													'ForcedSorting' => Array('IsPrimary' => 'desc', 'Priority' => 'desc', 'Status' => 'desc'),
													'Sorting' => Array('ISO' => 'asc'),
												)
											),
					'Fields' => Array
							        (
							            'CurrencyId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'ISO' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'Symbol' => Array('type' => 'string','default' => null),
							            'SymbolPosition' => Array('type' => 'int','default' => null,'formatter' => 'kOptionsFormatter','options' => Array(0 => 'la_Left', 1 => 'la_Right'),'use_phrases' => '1'),
							            'Name' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'RateToPrimary' => Array('type' => 'float', 'not_null' => 1, 'min_value_exc' => 0, 'formatter' => 'kFormatter', 'format' => '%0.4f', 'default' => 1),
							            'Modified' => Array('type' => 'int','not_null' => 1, 'default' => '#NOW#','formatter' => 'kDateFormatter'),
							            'Status' => Array('type' => 'int','not_null' => 1, 'default' => 0),
							            'IsPrimary' => Array('type' => 'int','not_null' => 1, 'default' => 0),
							            'Priority' => Array('type' => 'int','not_null' => 1, 'default' => 0),
							        ),

					'VirtualFields'	=> 	Array(
													'Translation' => Array('type'=>'string'),
											),
					'Grids'	=> Array(
								'Default'		=>	Array(
																	'Icons' => Array('default'=>'icon16_custom.gif','0_0'=>'icon16_currency_disabled.gif','1_0'=>'icon16_currency.gif','1_1'=>'icon16_currency_primary.gif'),
																	'Fields' => Array(
																			'CurrencyId' => Array( 'width'=>100, 'title'=>'la_col_Id', 'data_block'=>'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'ISO' => Array( 'width'=>100, 'title'=>'la_col_ISOCode', 'data_block' => 'currency_caption_td', 'filter_block' => 'grid_like_filter'),
																			'Translation' => Array( 'width'=>100, 'title'=>'la_col_CurrencyName', 'use_phrases' => 1, 'filter_block' => 'grid_like_filter'),
																			'RateToPrimary' => Array( 'width'=>100, 'title'=>'la_col_RateToPrimary', 'filter_block' => 'grid_float_range_filter'),
																			'Modified' => Array( 'width'=>100, 'title'=>'la_col_LastUpdated', 'filter_block' => 'grid_date_range_filter'),
																		),

																),
													),
	);

?>