<inp2:adm_SetPopupSize width="780" height="590"/>

<inp2:m_include t="incs/header"/>
<inp2:m_RenderElement name="combined_header" prefix="p" section="in-portal:browse" title_preset="options_edit"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();
				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							PrepareData();
							submit_event('po','<inp2:po_SaveEvent/>');
						}
					) );
				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							submit_event('po','OnCancel');
						}
				 ) );

				a_toolbar.Render();
			</script>
		</td>
	</tr>
</tbody>
</table>

<script type="text/javascript">
	var edit_id = null;
	var prices = new Array();
	var price_types = new Array();

	NumberFormatter.ThousandsSep = '<inp2:lang.current_Field name="ThousandSep" js_escape="1"/>';
	NumberFormatter.DecimalSep = '<inp2:lang.current_Field name="DecimalPoint" js_escape="1"/>';

	// var formatter = new NumberFormat();
	// formatter.setInputDecimal('<inp2:lang.current_Field name="DecimalPoint" js_escape="1"/>');
	// formatter.setSeparators(true, '<inp2:lang.current_Field name="ThousandSep" js_escape="1"/>', '<inp2:lang.current_Field name="DecimalPoint" js_escape="1"/>');

	function PrepareData() {
		SelectToString('options_list[]', '<inp2:po_InputName field="Values"/>');
		prices_str = '';

		for (var i in prices) {
			if (prices[i] == null) continue;
//			formatter.setNumber(prices[i]);
//			prices[i] = formatter.pars
			prices_str += i.replace(/\|/g, '\\|').replace(/\=/g, '\\=') + '=' + prices[i]  + '|'; // .replace(/\|/g, '\\|').replace(/\=/g, '\\=') + '|'
		}
		if(prices_str.length > 0) prices_str = prices_str.substring(0,prices_str.length-1);
//		alert('prices str: '+prices_str)
		document.getElementById('<inp2:po_InputName field="Prices"/>').value = prices_str;

		price_types_str = '';
		for (var i in price_types) {
			if (price_types[i] == null) continue;
			price_types_str += i.replace(/\|/g, '\\|').replace(/\=/g, '\\=') + '=' + price_types[i].replace(/\|/g, '\\|').replace(/\=/g, '\\=') + '|'
		}
		if(price_types_str.length > 0) price_types_str = price_types_str.substring(0,price_types_str.length-1);
		document.getElementById('<inp2:po_InputName field="PriceTypes"/>').value = price_types_str;
	}

	function SelectToString(aSelectId, aStringId) {
		aSelect = document.getElementById(aSelectId);
		// written by Slava, patched by Alex, modified by SergeyG
		var result = '';
		for (var i=0; i < aSelect.length; i++)
		{
			cur = aSelect.options[i];
			result += cur.value+',';
		}
		if(result.length > 0) result = result.substring(0,result.length-1);
		document.getElementById(aStringId).value = result;
		return result;
	}

	function add_option(aSelectId) {
		aSelect = document.getElementById(aSelectId);
		var el = document.getElementById('option_value');
		price = document.getElementById('option_price');
		price_val = NumberFormatter.Parse(price.value);
		price_type = document.getElementById('kernel_form').elements['option_price_type'];
		price_mod = '';
		if (price_type[0].checked) {
			price_mod = '$'
		}
		if (price_type[1].checked) {
			price_mod = '%'
		}

		if (price_val < 0) {
			sign = '-';
		}
		else {
			sign = '+';
		}

		if (price.value != '') {
			option_text = el.value + ': ' + sign + price_val + ' ' + price_mod;
		}
		else {
			option_text = el.value;
		}

		if (el)
		{
			if (el.value=='') return;
			var found = false;
			var valueArray;

			for (i = 0; i < aSelect.options.length; i++){
				if (aSelect.options[i].value == edit_id){
					found = true;
					break;
				}
			}
			if (!found){
				aSelect.options[aSelect.length] = new Option(option_text, el.value);
			}
			else {
				aSelect.options[i].text = option_text;
				aSelect.options[i].value = el.value;
			}
			//alert('set '+price.value+' unformatted is '+price_val)
			prices[el.value] = price_val
			price_types[el.value] = price_mod;
			el.value='';
			price.value = '';
			price_type[0].checked = false;
			price_type[1].checked = false;
			edit_id = null;
			document.getElementById('option_save').value = '<inp2:m_phrase label="la_button_add"/>';
		}
	}

	function cancel_edit() {
		var el = document.getElementById('option_value');
		document.getElementById('option_save').value = '<inp2:m_phrase label="la_button_add"/>';
		el.value = '';
		document.getElementById('option_price').value = '';
		document.getElementById('kernel_form').elements['option_price_type'][0].checked = false;
		document.getElementById('kernel_form').elements['option_price_type'][1].checked = false;
		edit_id = null;
	}

	function htmlspecialchars(str) {
		return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;");
	}

	function edit_option(aSelectId) {
		aSelect = document.getElementById(aSelectId);
		for (var i=0; i < aSelect.length; i++)
		{
			cur = aSelect.options[i];
			if(aSelect.options[i].selected == true) {
				edit_id = aSelect.options[i].value;
				document.getElementById('option_value').value = aSelect.options[i].value;

//				alert('setting: '+prices[edit_id]+' formatted is '+NumberFormatter.Format(prices[edit_id]))
				var formatted = NumberFormatter.Format(prices[edit_id]) ;
				document.getElementById('option_price').value = formatted == 0 ? '' : formatted;

				if (price_types[edit_id] == '$') {
					document.getElementById('kernel_form').elements['option_price_type'][0].checked = true;
				}
				if (price_types[edit_id] == '%') {
					document.getElementById('kernel_form').elements['option_price_type'][1].checked = true;
				}

			}
		}
		document.getElementById('option_save').value = '<inp2:m_phrase label="la_Text_Save"/>';
	}

	function delete_option(aSelectId) {
		aSelect = document.getElementById(aSelectId);
		if (!confirm('<inp2:m_phrase label="la_Delete_Confirm"/>')) return;
		for (var i=aSelect.length-1; i >= 0; i--)
		{
			cur = aSelect.options[i];
			if(aSelect.options[i].selected == true) {
				prices[aSelect.options[i].value] = null;
				price_types[aSelect.options[i].value] = null;
				aSelect.remove(i);
			}
		}
	}

	function catchEnter(e) {
		if (!e) return;
		//enter
	 	if (e.keyCode == 13) {
	 		add_option('options_list[]')
	 	}
	}

	function update_type(type) {
		switch (type) {
			case '1': //drop-down
				switch_option_values(1);
				break;
			case '5': //edit-box
				switch_option_values(0);
				break;
			case '4': //text-area
				switch_option_values(0);
				break;
			case '6': //checkboxes
				switch_option_values(1);
				break;
			case '3': //radio-buttons
				switch_option_values(1);
				break;
			default:
				switch_option_values(0);
		}
	}

	function switch_option_values(mode) {
		var elems = new Array('option_value', 'option_price', 'option_price_type_$','option_price_type_%','options_list[]',	'option_save', 'option_cancel', 'opt_edit_but', 'opt_del_but', 'opt_moveup_but', 'opt_movedown_but');
		for (var an_elem in elems) {
			the_elem = document.getElementById(elems[an_elem])
			the_elem.disabled = !mode;
			if (the_elem.tagName == 'INPUT' && the_elem.getAttribute('type') == 'button') {
				the_elem.className = mode ? 'button':'button-disabled';
			}
		}
	}

</script>
<inp2:m_DefineElement name="option_block">
	<option value="<inp2:m_param name="id"/>" <inp2:m_param name="selected"/>><inp2:m_param name="value"/>: <inp2:m_param name="sign"/><inp2:m_param name="price"/> <inp2:m_param name="price_type"/></option>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="option_block_js">
	prices['<inp2:m_param name="id"/>'] = '<inp2:m_param name="price"/>';
	price_types['<inp2:m_param name="id"/>'] = '<inp2:m_param name="price_type"/>';
</inp2:m_DefineElement>

<inp2:m_DefineElement name="options_list">
	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<inp2:m_inc param="tab_index" by="1"/>
		<td class="label-cell">
			<inp2:m_phrase label="la_fld_OptionValue"/>:
		</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
			<input type="text" name="option_value" id="option_value" value="" style="width: 300px" onkeydown="catchEnter(event)">&nbsp;<br/>
		</td>
	</tr>

	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<inp2:m_inc param="tab_index" by="1"/>
		<td class="label-cell">
			<inp2:m_phrase label="la_fld_OptionPrice"/>:
		</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
			<input type="text" name="option_price" id="option_price" value="" style="width: 40px">&nbsp;
			<input type="radio" name="option_price_type" value="$" id="option_price_type_$">&nbsp;<label for="option_price_type_$">$</label>&nbsp;&nbsp;
			<input type="radio" name="option_price_type" value="%" id="option_price_type_%">&nbsp;<label for="option_price_type_%">%</label>&nbsp;&nbsp;
			<br/>
			<input type="button" id="option_save" class="button" style="width: 80px" value="<inp2:m_phrase label="la_button_add"/>" onclick="add_option('options_list[]')">&nbsp;
			<input type="button" id="option_cancel" class="button" value="<inp2:m_phrase label="la_Cancel"/>" onclick="cancel_edit()">&nbsp;
		</td>
	</tr>

	<tr class="<inp2:m_odd_even odd='edit-form-odd' even='edit-form-even'/>">
		<inp2:m_inc param="tab_index" by="1"/>
		<td class="label-cell">&nbsp;</td>
		<td class="control-mid">&nbsp;</td>
		<td class="control-cell">
			<input type="hidden" value="" name="<inp2:po_InputName field="Values"/>" id="<inp2:po_InputName field="Values"/>">
			<input type="hidden" value="" name="<inp2:po_InputName field="Prices"/>" id="<inp2:po_InputName field="Prices"/>">
			<input type="hidden" value="" name="<inp2:po_InputName field="PriceTypes"/>" id="<inp2:po_InputName field="PriceTypes"/>">
			<table style="padding: 0px; margin: 0px">
				<tr>
					<td style="padding: 0px; margin: 0px">
						<select style="padding-left: 0px; width: 300px" name="options_list[]" id="options_list[]" multiple onchange="PrepareData()" ondblclick="edit_option('options_list[]')" size="10" style="width: 200px">
							<inp2:po_ShowOptions render_as="option_block" show="current" no_currency="1"/>
						</select>
						<script type="text/javascript">
							<inp2:po_ShowOptions render_as="option_block_js" show="current" js="1"/>
						</script>
					</td>
					<td style="padding-left: 5px; vertical-align: top">
						<input type="button" id="opt_edit_but" class="button" style="width: 90px" onclick="edit_option('options_list[]')" value="<inp2:m_phrase label="la_Text_Edit"/>"><br/>
						<input type="button" id="opt_del_but" class="button" style="width: 90px" onclick="delete_option('options_list[]')" value="<inp2:m_phrase label="la_Text_Delete"/>"><br/>
						<br/><br/><br/>
						<input type="button" id="opt_moveup_but" class="button" style="width: 90px" onclick="move_options_up('options_list[]', 1)" value="<inp2:m_phrase label="la_prompt_moveup"/>"><br/>
						<input type="button" id="opt_movedown_but" class="button" style="width: 90px" onclick="move_options_down('options_list[]', 1)" value="<inp2:m_phrase label="la_prompt_movedown"/>"><br/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</inp2:m_DefineElement>

<inp2:po_SaveWarning name="grid_save_warning"/>
<inp2:po_ErrorWarning name="form_error_warning"/>

<div id="scroll_container">
	<table class="edit-form">
		<inp2:m_RenderElement name="subsection" title="!la_Text_Option!"/>
			<inp2:m_RenderElement name="inp_edit_hidden" prefix="po" field="ProductId"/>
			<inp2:m_RenderElement name="inp_label" prefix="po" field="ProductOptionId" title="!la_fld_Id!"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="po" field="Name" title="!la_fld_Name!" size="40"/>
			<inp2:m_RenderElement name="inp_edit_checkbox" prefix="po" field="Required" title="!la_fld_Required!"/>
			<!--<inp2:m_RenderElement name="inp_edit_checkbox" prefix="po" field="Listable" title="!la_fld_Listable!"/>-->
			<inp2:m_RenderElement name="inp_edit_options" prefix="po" field="OptionType" title="!la_fld_OptionType!" onchange="update_type(this.value)"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="po" field="Priority" title="!la_fld_Priority!" size="2"/>
			<inp2:m_RenderElement name="options_list" prefix="po" field="Values" title="!la_fld_Values!" size="2"/>
		<inp2:m_RenderElement name="inp_edit_filler"/>
	</table>
</div>

<script type="text/javascript">
	update_type(document.getElementById('<inp2:po_InputName field="OptionType"/>').value);
</script>

<inp2:m_include t="incs/footer"/>