<inp2:adm_SetPopupSize width="820" height="570"/>

<inp2:m_include t="incs/header"/>

<inp2:m_if check="ord_OrderEditable">
	<inp2:m_SetParam grid="Default"/>
<inp2:m_else/>
	<inp2:m_SetParam grid="NotEditable"/>
</inp2:m_if>

<inp2:m_RenderElement name="combined_header" prefix="ord" section="in-commerce:orders" title_preset="orders_edit_items" grid="$grid" pagination="1" pagination_prefix="orditems" tab_preset="Default"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();
				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							submit_event('ord','<inp2:ord_SaveEvent/>');
						}
					) );
				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							submit_event('ord','OnCancelEdit');
						}
				 ) );

				a_toolbar.AddButton( new ToolBarSeparator('sep1') );

				a_toolbar.AddButton( new ToolBarButton('prev', '<inp2:m_phrase label="la_ToolTip_Prev" escape="1"/>', function() {
							go_to_id('ord', '<inp2:ord_PrevId/>');
						}
				 ) );
				a_toolbar.AddButton( new ToolBarButton('next', '<inp2:m_phrase label="la_ToolTip_Next" escape="1"/>', function() {
							go_to_id('ord', '<inp2:ord_NextId/>');
						}
				 ) );

				a_toolbar.AddButton( new ToolBarSeparator('sep2') );

				function edit(){
					std_edit_temp_item('orditems', 'in-commerce/orders/order_product_edit');
				}

				<inp2:m_if check="ord_OrderEditable">

					//Order items related:
					a_toolbar.AddButton( new ToolBarButton('new_item', '<inp2:m_phrase label="la_ToolTip_Add_Items" escape="1"/>',
							function() {
								openSelector('orditems', '<inp2:adm_SelectorLink prefix="ord" selection_mode="single" tab_prefixes="p"/>', '', null, 'OnSaveItems');
							} ) );

					a_toolbar.AddButton( new ToolBarButton('delete', '<inp2:m_phrase label="la_ToolTip_Delete" escape="1"/>',
							function() {
								std_delete_items('orditems')
							} ) );


					a_toolbar.AddButton( new ToolBarButton('recalculate_order', '<inp2:m_phrase label="la_RecalculateOrder"/>',
								function() {
									submit_event('ord', 'OnRecalculateItems');
								}	) );

					a_toolbar.AddButton( new ToolBarSeparator('sep3') );
				</inp2:m_if>

				a_toolbar.AddButton( new ToolBarButton('view', '<inp2:m_phrase label="la_ToolTip_View" escape="1"/>', function() {
							show_viewmenu(a_toolbar,'view');
						}
				) );

				a_toolbar.Render();

				<inp2:m_if check="ord_Status" is_not="incomplete">
					a_toolbar.HideButton('arrange');
				</inp2:m_if>

				<inp2:m_if check="ord_IsSingle">
					a_toolbar.HideButton('prev');
					a_toolbar.HideButton('next');
					a_toolbar.HideButton('sep1');
					//a_toolbar.HideButton('sep2');
				<inp2:m_else/>
					<inp2:m_if check="ord_IsLast" >
						a_toolbar.DisableButton('next');
					</inp2:m_if>
					<inp2:m_if check="ord_IsFirst" >
						a_toolbar.DisableButton('prev');
					</inp2:m_if>
				</inp2:m_if>

				// stuff for updating extended price based on price & quantity entered
				function CalculateSubtotal($prefix_special, $price_field, $result_id) {
					if (typeof(Grids[$prefix_special]) != 'object') {
						return false;
					}

					var $sub_total = 0;
					var $grid_items = Grids[$prefix_special].Items;

					for (var $i in $grid_items) {
						$id = $grid_items[$i].ItemId;
						var $price_control = document.getElementById($prefix_special + '['+$id+'][' + $price_field + ']');
						$sub_total += NumberFormatter.Parse($price_field == 'ExtendedPrice' ? $price_control.innerHTML : $price_control.value);
					}
					document.getElementById($result_id).innerHTML = NumberFormatter.Format($sub_total.toFixed(2));
				}

				function UpdateExtendedPrice($prefix_special, $id)
				{
					<inp2:m_if check="ord_OrderEditable">
						// 1. calculate current row extended price
						var $qty = NumberFormatter.Parse(document.getElementById($prefix_special+'['+$id+'][Quantity]').value);
						var $price = NumberFormatter.Parse(document.getElementById($prefix_special+'['+$id+'][Price]').value);

						var $ext_price = Math.round($qty*$price*100)/100;
						document.getElementById($prefix_special+'['+$id+'][ExtendedPrice]').innerHTML = NumberFormatter.Format($ext_price.toFixed(2));

						// 2. recalculate subtotal
						CalculateSubtotal($prefix_special, 'ExtendedPrice', 'order_subtotal');
					</inp2:m_if>

					// 3. recalculate return total
					CalculateSubtotal('orditems', 'ReturnAmount', 'order_returntotal');
				}
			</script>
		</td>

		<inp2:m_RenderElement name="search_main_toolbar" prefix="orditems" grid="$grid"/>
	</tr>
</tbody>
</table>

<inp2:m_DefineElement name="option_value_element">
	<inp2:m_param name="value"/> <inp2:m_if check="m_ParamEquals" name="price" value=""><inp2:m_else/> (<inp2:m_param name="sign"/><inp2:m_param name="price"/> <inp2:m_param name="price_type"/>)</inp2:m_if>
	<inp2:m_if check="m_ParamEquals" name="is_last" value="1"><inp2:m_else/>, </inp2:m_if>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="option_element">
	<inp2:m_if check="m_ParamEquals" param="type" value="6"> <!-- checkboxes - multiple -->
		<strong><inp2:m_param name="option"/>:</strong>
			<inp2:PrintOptionValues render_as="option_value_element"/>
	<inp2:m_else/>
			<strong><inp2:m_param name="option"/>:</strong> <inp2:m_param name="value"/>
				<inp2:m_if check="m_ParamEquals" name="price" value=""><inp2:m_else/> (<inp2:m_param name="sign"/><inp2:m_param name="price"/> <inp2:m_param name="price_type"/>)</inp2:m_if>
	</inp2:m_if><br/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="option_value_element_no_price">
	<inp2:m_param name="value"/>
	<inp2:m_if check="m_ParamEquals" name="is_last" value="1"><inp2:m_else/>, </inp2:m_if>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="option_element_no_price">
	<inp2:m_if check="m_ParamEquals" param="type" value="6"> <!-- checkboxes - multiple -->
		<strong><inp2:m_param name="option"/>:</strong>
			<inp2:PrintOptionValues render_as="option_value_element_no_price"/>
	<inp2:m_else/>
			<strong><inp2:m_param name="option"/>:</strong> <inp2:m_param name="value"/>
	</inp2:m_if><br/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="product_image">
	<img src="<inp2:m_param name="img_path" />" title="<inp2:m_param name="alt" />" alt="<inp2:m_param name="alt" />" <inp2:m_param name="img_size" /> border="0" /><br/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="grid_productname_td" format="" module="">
	<inp2:m_if check="m_GetConfig" name="ShowProductImagesInOrders">
		<div style="width: 120px;">
			<inp2:p_Image render_as="product_image" thumbnail="1" DefaultImage="noimage.gif" MaxWidth="120" MaxHeight="120" DefaultWidth="120" />
		</div>
	</inp2:m_if>

	<inp2:Field field="$field" first_chars="50"/> (<inp2:Field field="ProductId"/>)
	<inp2:m_if check="ord_BackOrderFlag"><span class="error"><inp2:m_Phrase label="la_ItemBackordered"/></span></inp2:m_if>
	<inp2:m_if check="HasOptions">
		<br/>
		<small>
			<inp2:m_if check="FieldEquals" field="OptionsSelectionMode" value="0">
				<!-- selectable options -->
				<inp2:PrintOptions render_as="option_element"/>
			<inp2:m_else/>
				<!-- listed combinations -->
				<inp2:PrintOptions render_as="option_element_no_price"/>
			</inp2:m_if>
		</small>
	</inp2:m_if>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="grid_edit_td">
	<input type="text" onkeyup="UpdateExtendedPrice('<inp2:m_param name="PrefixSpecial"/>', <inp2:{$PrefixSpecial}_Field field="OrderItemId"/>);" class="text" name="<inp2:{$PrefixSpecial}_InputName field="$field"/>" id="<inp2:{$PrefixSpecial}_InputName field="$field"/>" value="<inp2:{$PrefixSpecial}_field field="$field" grid="$grid"/>" size="4">
</inp2:m_DefineElement>

<inp2:m_DefineElement name="grid_quantity_td">
	<inp2:m_if check="FieldEquals" field="Type" value="1">
		<input type="text" onkeyup="UpdateExtendedPrice('<inp2:m_param name="PrefixSpecial"/>', <inp2:{$PrefixSpecial}_Field field="OrderItemId"/>);" class="text" name="<inp2:{$PrefixSpecial}_InputName field="$field"/>" id="<inp2:{$PrefixSpecial}_InputName field="$field"/>" value="<inp2:{$PrefixSpecial}_field field="$field" grid="$grid"/>" size="4">
	<inp2:m_else />
		<span class="text"><inp2:{$PrefixSpecial}_field field="$field" grid="$grid"/></span>
		<inp2:m_RenderElement name="inp_edit_hidden" prefix="$PrefixSpecial" field="$field"/>
	</inp2:m_if>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="grid_price_td">
	<input type="text" onkeyup="UpdateExtendedPrice('<inp2:m_param name="PrefixSpecial"/>', <inp2:{$PrefixSpecial}_Field field="OrderItemId"/>);" class="text" name="<inp2:{$PrefixSpecial}_InputName field="$field"/>" id="<inp2:{$PrefixSpecial}_InputName field="$field"/>" value="<inp2:{$PrefixSpecial}_field field="$field" grid="$grid"/>" size="5">
</inp2:m_DefineElement>

<inp2:m_DefineElement name="grid_extendedprice_td">
	<span id="<inp2:InputName field="$field"/>"><inp2:Field field="$field" grid="$grid" format="%.2f"/></span>
	<script type="text/javascript">UpdateExtendedPrice('<inp2:m_param name="PrefixSpecial"/>',<inp2:Field field="OrderItemId"/>);</script>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="orderitems_total_td">
	<inp2:m_if check="FieldOption" field="$field" option="totals">
		<inp2:FieldOption field="$field" option="totals" result_to_var="totals"/>
		'<inp2:FieldTotal field="$field" function="$totals"/>'
	<inp2:m_else/>
		<inp2:m_if check="m_Param" name="field" equals_to="ReturnAmount">
			'<span id="order_returntotal">0.00</span>'
		</inp2:m_if>

		<inp2:m_if check="m_Param" name="field" equals_to="ExtendedPrice">
			<inp2:m_if check="ord_OrderEditable">
				'<span id="order_subtotal">0.00</span>'
			<inp2:m_else/>
				'<span id="order_subtotal"><inp2:ord_Field name="SubTotal"/></span>'
			</inp2:m_if>
		</inp2:m_if>

		<inp2:m_ifnot check="m_Param" name="field" equals_to="ReturnAmount|ExtendedPrice">
		'&nbsp;'
		</inp2:m_ifnot>
	</inp2:m_if>
	<inp2:m_ifnot check="m_Param" name="is_last">, </inp2:m_ifnot>
</inp2:m_DefineElement>

<inp2:m_RenderElement name="grid" grid="$grid" PrefixSpecial="orditems" IdField="OrderItemId" totals_block="orderitems_total_td" totals_render_as="grid_total_row"/>

<script type="text/javascript">
	Grids['orditems'].SetDependantToolbarButtons( new Array('delete') );

	<inp2:m_if check="ord_OrderEditable">
		CalculateSubtotal('orditems', 'ExtendedPrice', 'order_subtotal');
	</inp2:m_if>

	CalculateSubtotal('orditems', 'ReturnAmount', 'order_returntotal');
</script>

<input type="hidden" name="main_prefix" id="main_prefix" value="ord">

<inp2:m_include t="incs/footer"/>