<?php
/**
* @version	$Id: products_item.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	class ProductsItem extends kCatDBItem
	{
		function GetPackageContentIds()
		{
			$ids_string = trim($this->GetDBField('PackageContent'), '|');
			if ($ids_string) {
				$ids_array = explode('|', $ids_string);
				return $ids_array;
			}
			else {
				return array();
			}
		}

		/**
		 * Returns field values from primary pricing for product
		 *
		 * @return array
		 */
		function getPrimaryPricing()
		{
			if (!$this->Application->IsAdmin()) {
				$user_id = $this->Application->RecallVar('user_id');
				$primary_group = $user_id != -2 ? $this->Conn->GetOne('SELECT GroupId FROM '.TABLE_PREFIX.'UserGroup WHERE PrimaryGroup = 1 AND PortalUserId = '.$user_id) : false;
				if ($primary_group) {
					$sql = 'SELECT Price, Cost
						FROM '.TABLE_PREFIX.'ProductsPricing
						WHERE (ProductId = '.$this->GetID().') AND (GroupId = '.$primary_group.')
						ORDER BY MinQty';
					$a_values = $this->Conn->GetRow($sql);
					if ($a_values !== false) {
						return $a_values;
					}
				}
			}
			$pr_table = $this->Application->getUnitOption('pr', 'TableName');
			if ($this->mode == 't') {
				$pr_table = $this->Application->GetTempName($pr_table, 'prefix:'.$this->Prefix);
			}

			$sql = 'SELECT Price, Cost
					FROM '.$pr_table.'
					WHERE ('.$this->IDField.' = '.$this->GetID().') AND (IsPrimary = 1)';
			return $this->Conn->GetRow($sql);
		}

	}

?>