<?php
/**
* @version	$Id: products_option_combination_item.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	class kPOCItem extends kDBItem
	{

		/**
		 * Returns unformatted field value
		 *
		 * @param string $field
		 * @return string
		 * @access public
		 */
		function GetDBField($field)
		{
			if ($field == 'FinalPrice') {
				$product =& $this->Application->recallObject('p');

				switch($this->GetDBField('PriceType'))
				{
					case 1: // = (override)
						return $this->GetDBField('Price');
						break;
					case 2: // flat
						return $product->GetDBField('Price') + $this->GetDBField('Price');
						break;
					case 3: // percent
						return $product->GetDBField('Price') * (1 + $this->GetDBField('Price')/100);
						break;
				}
			}
			else {
				$ret = parent::GetDBField($field);
			}
			return $ret;
		}

	}

?>