<?php
/**
* @version	$Id: gift_certificates_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	$config	= Array (
		'Prefix' => 'gc',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'GiftCertificateEventHandler', 'file' => 'gift_certificates_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'GiftCertificateTagProcessor', 'file' => 'gift_certificates_tp.php', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,

		'Hooks' => Array (
			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => 'ord',
				'HookToSpecial' => '',
				'HookToEvent' => Array( 'OnUpdateCart', 'OnCheckout' ),
				'DoPrefix' => '',
				'DoSpecial' => '',
				'DoEvent' => 'OnApplyGiftCertificate',
			),
		),

		'QueryString' => Array (
			1	=>	'id',
			2	=>	'page',
			3	=>	'event',
			4 =>	'mode',
		),

		'IDField' => 'GiftCertificateId',
		'StatusField' => Array('Status'),
		'TitleField' => 'Recipient',
		'TableName' => TABLE_PREFIX.'GiftCertificates',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('gc' => '!la_title_AddingGiftCertificate!'),
				'edit_status_labels' => Array ('gc' => '!la_title_EditingGiftCertificate!'),
				'new_titlefield' => Array ('gc' => '!la_title_NewGiftCertificate!'),
			),

			'gift_certificates_list' => Array ('prefixes' => Array ('gc_List'), 'format' => "!la_title_GiftCertificates!",),
			'gift_certificates_edit' => Array ('prefixes' => Array ('gc'), 'format' => "#gc_status# '#gc_titlefield#' - !la_title_General!",),
		),

		'PermSection' => Array ('main' => 'in-commerce:gift-certificates'),

		'Sections' => Array (
			'in-commerce:gift-certificates' => Array (
				'parent'		=>	'in-commerce:discounts_folder',
				'icon'			=>	'discounts',
				'label'			=>	'la_tab_GiftCertificates',
				'url'			=>	Array('t' => 'in-commerce/discounts/gift_certificate_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
				'priority'		=>	2.3,
				'type'			=>	stTAB,
			),
		),

		'FilterMenu' => Array (
			'Groups' => Array(
				Array ('mode' => 'AND', 'filters' => Array(0,1,2), 'type' => WHERE_FILTER),
			),

			'Filters' => Array(
				0	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => 'Status != 1' ),
				1	=>	Array('label' => 'la_Used', 'on_sql' => '', 'off_sql' => 'Status != 2'  ),
				2	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => 'Status != 0'  ),
			)
		),

		'ListSQLs' => Array ('' => 'SELECT %1$s.* %2$s FROM %1$s',),
		'ItemSQLs' => Array ('' => 'SELECT * FROM %1$s',),

		'ListSortings' => Array (
			'' => Array(
				'Sorting' => Array('Recipient' => 'asc'),
			)
		),

		'Fields' => Array (
		    'GiftCertificateId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'OrderId' => Array ('type' => 'int', 'default' => 0),
		    'Status' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 1 => 'la_Enabled', 2 => 'la_Used', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1 ),
		    'SendVia' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 0 => 'la_opt_Email', 1 => 'la_opt_PostalMail'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0 ),
		    'Purchaser' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'Recipient' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
	        'RecipientEmail' => Array('type' => 'string', 'formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'sample_value' => 'email@domain.com', 'not_null' => '1', 'required'=>1, 'default' => '', 'error_msgs' => Array('invalid_format'=>'!la_invalid_email!') ),
		    'RecipientFirstname' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientLastname' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientAddress1' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientAddress2' => Array('type'=>'string', 'default'=>null, 'max_len'=>255),
		    'RecipientCity' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientState' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientZipcode' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
			'RecipientCountry' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
		            				'options_sql'=>'SELECT %1$s
															FROM '.TABLE_PREFIX.'StdDestinations
															LEFT JOIN '.TABLE_PREFIX.'Phrase
																ON '.TABLE_PREFIX.'Phrase.Phrase = '.TABLE_PREFIX.'StdDestinations.DestName
															WHERE
																DestType=1
																AND
																LanguageId = %2$s
															ORDER BY Translation',
							            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation',
							           'not_null' => '1','default' => 'USA', 'required'=>1
			),
		    'RecipientPhone' => Array('type'=>'string','default'=>null, 'max_len'=>255),
		    'Message' => Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
		    'Code' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255, 'unique'=>Array('Code')),
		    'AddDate' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#',),
		    'Expiration' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null,),
		    'Amount' => Array('type'=>'double', 'default' => null, 'required' => 1, 'min_value_exc' => 0),
		    'Debit' => Array('type'=>'double', 'default' => null),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array('default' => 'icon16_custom.gif', 1 => 'icon16_discount.gif', 2 => 'icon16_discount_pending.gif', 0 => 'icon16_discount_disabled.gif'),
				'Fields' => Array (
					'GiftCertificateId'	=> Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
					'Code' => Array ('title' => 'la_col_Code', 'filter_block' => 'grid_like_filter'),
					'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter'),
					'Debit' => Array ('title' => 'la_col_RemainingAmount', 'filter_block' => 'grid_float_range_filter'),
					'Amount' => Array ('title' => 'la_col_Amount', 'filter_block' => 'grid_float_range_filter'),
					'Expiration' => Array ('title'=>'la_col_Expiration', 'filter_block' => 'grid_date_range_filter'),
				),
			),
		),
	);

?>