<inp2:m_include template="in-commerce/blocks/checkout/options"/>

<inp2:m_DefineElement name="product_image">
	<img src="<inp2:m_param name="img_path" />" title="<inp2:m_param name="alt" />" alt="<inp2:m_param name="alt" />" <inp2:m_param name="img_size" /> border="0" /><br/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="orderitem_elem">
	<tr class="cart-item">
		<inp2:m_if check="m_GetConfig" name="ShowProductImagesInOrders">
			<td width="120">
				<inp2:p_Image render_as="product_image" thumbnail="1" DefaultImage="in-commerce/img/no_picture_list.gif" MaxWidth="120" MaxHeight="120" DefaultWidth="120" />
			</td>
		</inp2:m_if>

		<td>
			<strong><inp2:Field name="ProductName"/></strong><inp2:m_if check="ord_BackorderFlag"> <span class="error"><inp2:m_phrase label="lu_cart_BackorderFlag" /></span></inp2:m_if>
			<inp2:m_if check="HasOptions">
				<br/>
				<span style="font-size: 8pt">
				<inp2:m_if check="DisplayOptionsPricing"> <!-- selectable options or overriding combination -->
					<inp2:PrintOptions render_as="option_element" currency="selected"/>
				<inp2:m_else/> <!-- listed combinations -->
					<inp2:PrintOptions render_as="option_element_no_price"/>
				</inp2:m_if>
				</span>
				<br/>
			</inp2:m_if>
			<inp2:m_if check="HasDiscount">
				<br />
				<inp2:m_Phrase label="lu_comm_RegularPrice" />: <inp2:Field name="FlatPrice" currency="selected"/><br />
				<inp2:m_Phrase label="lu_comm_Discount" />: <span class="price1"><inp2:Field name="ItemDiscount" currency="selected" negative="1"/></span>
			</inp2:m_if>
		</td>
		<td>
			<strong><inp2:Field name="Price" currency="selected"/></strong>
		</td>
		<td><inp2:Field name="Quantity"/></td>
		<td><strong><inp2:Field name="ExtendedPrice" currency="selected"/></strong></td>
	</tr>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="order_form_shipping">
	<!-- shipping -->
	<table width="100%" cellpadding="0" cellspacing="0">
		<tr class="cart-header">
			<td colspan="2"><inp2:m_Phrase label="lu_comm_ShipmentInfo"/></td>
		</tr>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_Name"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="ShippingTo"/></td>
		</tr>
		<inp2:m_if check="Field" name="ShippingCompany">
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_Company"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="ShippingCompany"/></td>
		</tr>
		</inp2:m_if>
		<inp2:m_if check="Field" name="ShippingEmail">
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_EmailAddress"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="ShippingEmail"/></td>
		</tr>
		</inp2:m_if>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_PhoneNumber"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="ShippingPhone"/></td>
		</tr>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_FaxNumber"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="ShippingFax"/></td>
		</tr>
		<tr class="block-data2">
			<td style="vertical-align: top;"><strong><inp2:m_Phrase label="lu_comm_Address"/></strong>:</td>
			<td style="text-align: right;">
				<inp2:m_if check="FieldEquals" field="ShippingAddress1" value="" inverse="inverse">
					<inp2:Field field="ShippingAddress1"/><br>
				</inp2:m_if>

				<inp2:m_if check="FieldEquals" field="ShippingAddress2" value="" inverse="inverse">
					<inp2:Field field="ShippingAddress2"/><br>
				</inp2:m_if>
				<inp2:PrintLocation type="Shipping"/>
			</td>
		</tr>
	</table>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="order_form_billing">
	<!-- billing -->
	<table width="100%" cellpadding="0" cellspacing="0">
		<tr class="cart-header">
			<td colspan="2"><inp2:m_Phrase label="lu_comm_BillingInfo"/></td>
		</tr>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_Name"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingTo"/></td>
		</tr>
		<inp2:m_if check="Field" name="BillingCompany">
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_Company"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingCompany"/></td>
		</tr>
		</inp2:m_if>
		<inp2:m_if check="Field" name="BillingEmail">
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_EmailAddress"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingEmail"/></td>
		</tr>
		</inp2:m_if>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_PhoneNumber"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingPhone"/></td>
		</tr>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_FaxNumber"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingFax"/></td>
		</tr>
		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_Company"/></strong>:</td>
			<td style="text-align: right;"><inp2:Field field="BillingCompany"/></td>
		</tr>
		<tr class="block-data2">
			<td style="vertical-align: top;"><strong><inp2:m_Phrase label="lu_comm_Address"/></strong>:</td>
			<td style="text-align: right;">
				<inp2:m_if check="FieldEquals" field="BillingAddress1" value="" inverse="inverse">
					<inp2:Field field="BillingAddress1"/><br>
				</inp2:m_if>

				<inp2:m_if check="FieldEquals" field="BillingAddress2" value="" inverse="inverse">
					<inp2:Field field="BillingAddress2"/><br>
				</inp2:m_if>
				<inp2:PrintLocation type="Billing"/>
			</td>
		</tr>

		<tr class="block-data2">
			<td><strong><inp2:m_Phrase label="lu_comm_PaymentType"/>:</strong></td>
			<td style="text-align: right;"><inp2:Field name="PaymentType" /></td>
		</tr>

		<inp2:m_if check="UsingCreditCard">
			<tr class="block-data2">
				<td><strong><inp2:m_Phrase label="lu_comm_NameOnCard"/>:</strong></td>
				<td style="text-align: right;"><inp2:Field name="PaymentNameOnCard"/></td>
			</tr>
			<tr class="block-data2">
				<td><strong><inp2:m_Phrase label="lu_comm_CardType"/>:</strong></td>
				<td style="text-align: right;"><inp2:Field name="PaymentCardType" /></td>
			</tr>
			<tr class="block-data2">
				<td style="vertical-align: top;"><strong><inp2:m_Phrase label="lu_comm_CardNumber"/>:</strong></td>
				<td style="text-align: right;"><inp2:Field name="PaymentAccount" masked="masked"/></td>
			</tr>
			<tr class="block-data2">
				<td style="vertical-align: top;"><strong><inp2:m_Phrase label="lu_comm_Exp"/>:</strong></td>
				<td style="text-align: right;"><inp2:Field name="PaymentCCExpDate"/></td>
			</tr>
		</inp2:m_if>
	</table>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="order_form">
	<table class="block-no-border">
		<tr>
			<td class="block-header">
				<inp2:m_Phrase label="lu_comm_OrderPreview"/>
			</td>
		</tr>
	</table>

	<table class="block-no-border">
		<tr>
			<td class="block-data">
				<strong><inp2:m_Phrase label="lu_comm_OrderNumber"/><inp2:Field name="OrderNumber"/></strong>
			</td>
		</tr>
	</table>

	<inp2:m_if check="OrderHasTangibleItems">
		<table class="block-no-border">
			<tr>
				<td width="49%">
					<inp2:m_RenderElement name="order_form_shipping" PrefixSpecial="ord"/>
				</td>
				<td>&nbsp;</td>
				<td width="49%">
					<inp2:m_RenderElement name="order_form_billing" PrefixSpecial="ord"/>
				</td>
			</tr>
		</table>
	<inp2:m_else />
		<table class="block-no-border">
			<tr>
				<td>
					<inp2:m_RenderElement name="order_form_billing" PrefixSpecial="ord"/>
				</td>
			</tr>
		</table>
	</inp2:m_if>

	<table>
		<tr class="cart-header">
			<inp2:m_if check="m_GetConfig" name="ShowProductImagesInOrders">
				<td colspan="2"><inp2:m_Phrase label="lu_comm_ProductDescription"/></td>
			<inp2:m_else/>
				<td><inp2:m_Phrase label="lu_comm_ProductDescription"/></td>
			</inp2:m_if>

			<td><inp2:m_Phrase label="lu_comm_YourPrice"/></td>

			<td><inp2:m_Phrase label="lu_comm_Qty"/>.</td>
			<td><inp2:m_Phrase label="lu_comm_Total"/></td>
		</tr>

		<inp2:ord_ListOrderItems render_as="orderitem_elem"/>

		<tr class="cart-subtotal">
			<td>
				<inp2:m_if check="ord_HasDiscount">
					<inp2:m_Phrase label="lu_comm_TotalSavings" />: <span class="price1"><inp2:ord_Field name="DiscountTotal" currency="selected" /></span><br />
				</inp2:m_if>&nbsp;
			</td>
			<td style="text-align: right;" colspan="<inp2:m_if check="m_GetConfig" name="ShowProductImagesInOrders">5<inp2:m_else/>4</inp2:m_if>">
				<strong><inp2:m_Phrase label="lu_comm_Subtotal"/>: <span class="price1"><inp2:Field name="SubTotal" currency="selected"/></span></strong>
			</td>
		</tr>
	</table>

	<table>
		<tr class="cart-header">
		    <td>
				<inp2:m_Phrase label="lu_comm_OrderTotal"/>
			</td>
		</tr>
	</table>

	<table class="block-no-border">

		<inp2:m_DefineElement name="shipping_total">
			<tr class="block-data2">
				<td style="text-align: right;"><inp2:m_Phrase label="lu_comm_ShippingCost"/> (<inp2:ord_ShippingType />):</td>
				<td style="text-align: right;"><inp2:ord_Field name="ShippingCost" currency="selected"/></td>
			</tr>
		</inp2:m_DefineElement>

		<inp2:m_DefineElement name="processing_total">
			<tr class="block-data2">
				<td style="text-align: right;"><inp2:m_Phrase label="lu_comm_ProcessingFee"/>: </td>
				<td style="text-align: right;"><inp2:ord_Field name="ProcessingFee" currency="selected"/></td>
			</tr>
		</inp2:m_DefineElement>

		<inp2:m_DefineElement name="sub_total">
			<tr class="block-data2">
				<td style="text-align: right;"><inp2:m_Phrase label="lu_comm_SubTotal"/>: </td>
				<td style="text-align: right;"><inp2:ord_Field name="AmountWithoutVAT" currency="selected"/></td>
			</tr>
		</inp2:m_DefineElement>

		<inp2:m_DefineElement name="vat_total">
			<tr class="block-data2">
				<td style="text-align: right;"><inp2:m_Phrase label="lu_comm_VAT"/> <inp2:ord_Field name="VATPercent"/>%: </td>
				<td style="text-align: right;"><inp2:ord_Field name="VAT" currency="selected"/></td>
			</tr>
		</inp2:m_DefineElement>

		<inp2:ord_PrintTotals
			shipping_render_as="shipping_total"
			processing_render_as="processing_total"
			sub_total_render_as="sub_total"
			vat_render_as="vat_total"/>

		<tr class="block-data2">
		  <td class="price3" style="text-align: right;"><strong><inp2:m_Phrase label="lu_comm_GrandTotal"/>:</strong></td>
			<td class="price3" style="text-align: right;"><span class="price1"><inp2:Field name="TotalAmount" currency="selected"/></span></td>
		</tr>
	</table>

	<br />
</inp2:m_DefineElement>

<inp2:ord_ShowOrder render_as="order_form" />

<table class="block-no-border">
	<tr class="block-data2">
		<td class="price3" style="text-align: right;">
			<form method="POST" action="<inp2:ord_GetFormAction/>">
				<inp2:ord_GetFormHiddenFields return_template="in-commerce/checkout/checkout_success"
											  cancel_template="in-commerce/checkout/billing" />
				<inp2:m_if check="ord_NeedsPlaceButton">
					<input type="submit" value="<inp2:m_Phrase label="lu_order_CompleteOrder" />" class="button">
				</inp2:m_if>
			</form>
		</td>
	</tr>
</table>