<?php
/**
* @version	$Id: upgrades.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/
	$upgrade_class = 'InCommerceUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "Core" module
	 *
	 */
	class InCommerceUpgrades extends kHelper {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				// update icon
				$root_category = $this->Application->findModule('Name', 'In-Commerce', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-commerce/img/menu_products.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('p', 'in-commerce/product/details', 'in-commerce/designs/detail');

				// copy store name to company name				
				$store_name = $this->Application->ConfigValue('Comm_StoreName');
				
				$sql = 'UPDATE ' . TABLE_PREFIX . 'ConfigurationValues
						SET VariableValue = ' . $this->Conn->qstr($store_name) . '
						WHERE VariableName = "Comm_CompanyName"';
				$this->Conn->Query($sql);
			}
		}

		/**
		 * Replaces deprecated detail template design with new one
		 *
		 * @param string $prefix
		 * @param string $from_template
		 * @param string $to_template
		 */
		function _updateDetailTemplate($prefix, $from_template, $to_template)
		{
			$sql = 'SELECT CustomFieldId
					FROM ' . TABLE_PREFIX . 'CustomField
					WHERE FieldName = "' . $prefix . '_ItemTemplate"';
			$custom_field_id = $this->Conn->GetOne($sql);

			$ml_formatter =& $this->Application->recallObject('kMultiLanguage');
			/* @var $ml_formatter kMultiLanguage */

			$field = $ml_formatter->LangFieldName('cust_' . $custom_field_id, true);

			$sql = 'UPDATE ' . TABLE_PREFIX . 'CategoryCustomData
					SET ' . $field . ' = "' . $to_template . '"
					WHERE ' . $field . ' = "' . $from_template . '"';
			$this->Conn->Query($sql);
		}
	}