<?php
/**
* @version	$Id: zones_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'z',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ZonesEventHandler','file'=>'zones_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ZonesTagProcessor','file'=>'zones_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array(),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'IDField'			=>	'ZoneID',
					'TitleField'		=>  'Name',
					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('z'=>'!la_title_AddingShippingZone!'),
																		'edit_status_labels'	=> Array('z'=>'!la_title_EditingShippingZone!'),
																		'new_titlefield'		=> Array('z'=>'!la_title_NewShippingZone!'),
																),
												'zones_edit'		=>	Array(	'prefixes' => Array('z'), 'format' => "#z_status# - '#z_titlefield#'"),
											),
					'TableName'			=>	TABLE_PREFIX.'ShippingZones',
					'ForeignKey' 		=> 	'ShippingTypeID', //Name of the field in this table used as ForeignKey
					'ParentTableKey' 	=> 	'ShippingID', //Name of the field in parent table linked with ForeignKey
					'ParentPrefix'	=> 's', //Prefix of parent item
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'SubItems' =>	Array('dst', 'sc'),

					'ListSQLs'			=>	Array(	''=>	'SELECT * FROM %s'),
																		 // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>	'SELECT * FROM %s'),

					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields' => Array (
						'ZoneID' => Array('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'ShippingTypeID' => Array('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'Name' => Array('type' => 'string', 'required'=>true, 'max_len'=>100, 'error_msgs' => Array('required' => 'Please fill in'), 'not_null' => 1, 'default' => '', ),
			            'Type' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options' => Array(1 => 'la_ByCountry', 2 => 'la_ByState', 3 => 'la_ByZIP'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1, ),
			            'CODallowed' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options' => Array(1 => 'la_Allowed', 0 => 'la_NotAllowed'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1, ),
					),

					'Grids'	=> Array(
								'Default'		=>	Array(
																	'Icons' => Array('default'=>'icon16_custom.gif'),
																	'Fields' => Array(
																	'ZoneID' => Array( 'width'=>150, 'title'=>'la_col_Id', 'data_block'=>'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																	'Name' => Array( 'width'=>150, 'title'=>'la_col_Title', 'filter_block' => 'grid_like_filter'),
																	'CODallowed' => Array( 'width'=>100, 'title'=>'la_col_CODallowed', 'filter_block' => 'grid_options_filter')
																			),

																),
													),
	);

?>