<?php
/**
* @version	$Id: gw_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class GatewayEventHandler extends kDBEventHandler {

	function OnSaveValues($event)
	{
		// if there is no id - it means we need to create an item
		$item_id = $this->getPassedID($event);
		$event->setPseudoClass('_List');

		$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
		$PaymentType_info = $this->Application->GetVar( 'pt' );
		$GWConfigValue = $this->Application->recallObject('gwfv');
		$GWConfigValue->SetDBField('PaymentTypeId', $this->Application->GetVar('pt_id'));

		//deleting old values
		$sql = 'DELETE FROM '.$GWConfigValue->TableName.' WHERE PaymentTypeId = '.$this->Application->GetVar('pt_id');
		$res = $this->Conn->Query($sql);

		//selecting fields for selected gateway only
		$sql = 'SELECT GWConfigFieldId FROM '.TABLE_PREFIX.'GatewayConfigFields
					WHERE GatewayId = '.$PaymentType_info[$this->Application->GetVar('pt_id')]['GatewayId'];
		$res = $this->Conn->GetCol($sql);

		if($items_info)
		{
			foreach($res as $gw_field_id)
			{
				$field_values = $items_info[$gw_field_id];
				$field_values['GWConfigFieldId'] = $gw_field_id;

				$GWConfigValue->SetFieldsFromHash($field_values);
				if( $GWConfigValue->Create() )
				{
					$event->status=kEvent::erSUCCESS;
				}
				else
				{
					$event->status=kEvent::erFAIL;
					break;
				}
			}
		}
	}

	protected function OnCheckGateways($event)
	{
		if ( !$this->Application->isAdminUser ) {
			return;
		}

		$gateways = glob(GW_CLASS_PATH . DIRECTORY_SEPARATOR . '*.php');

		if ( !$gateways ) {
			return;
		}

		foreach ($gateways as $gateway_file) {
			$class_name = false;
			include_once($gateway_file);

			if ( !$class_name ) {
				continue;
			}

			/** @var kGWBase $tmp */
			$tmp = new $class_name();

			$tmp->Install();
		}
	}
}