<?php
/**
* @version	$Id: affiliate_plans_brackets_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatePlansBracketsEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnMoreBrackets' => Array ('subitem' => 'add|edit'),
				'OnInfinity' => Array ('subitem' => 'add|edit'),
				'OnArrange' => Array ('subitem' => 'add|edit'),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Adds additional 5 empty brackets
		 *
		 * @param kEvent $event
		 */
		function OnMoreBrackets($event)
		{
			$event->redirect = false;

			$brackets_helper = $this->Application->recallObject('BracketsHelper');
			$brackets_helper->InitHelper('FromAmount', 'ToAmount', Array('Percent' => '') );
			$brackets_helper->OnMoreBrackets($event);
		}

		/**
		 * Arrange brackets
		 *
		 * @param kEvent $event
		 */
		function OnArrange($event)
		{
			$event->redirect = false;
			$brackets_helper = $this->Application->recallObject('BracketsHelper');
			$brackets_helper->InitHelper('FromAmount', 'ToAmount', Array('Percent' => '') );

			$brackets_helper->arrangeBrackets($event);
			$event->CallSubEvent('OnPreSaveBrackets');
		}

		/**
		 * Arrange infinity brackets
		 *
		 * @param kEvent $event
		 */
		function OnInfinity($event)
		{
			$event->redirect = false;
			$brackets_helper = $this->Application->recallObject('BracketsHelper');
			$brackets_helper->InitHelper('FromAmount', 'ToAmount', Array('Percent' => '') );
			$brackets_helper->arrangeBrackets($event);

			$event->CallSubEvent('OnPreSaveBrackets');

			$brackets_helper->OnInfinity($event);

			$event->CallSubEvent('OnPreSaveBrackets');
		}

		/**
		 * Occurs before updating item
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemUpdate(kEvent $event)
		{
			parent::OnBeforeItemUpdate($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			$linked_info = $object->getLinkedInfo();
			$object->SetDBField($linked_info['ParentTableKey'], $linked_info['ParentId']);

			/** @var kBracketsHelper $brackets_helper */
			$brackets_helper = $this->Application->recallObject('BracketsHelper');

			$brackets_helper->InitHelper('FromAmount', 'ToAmount', Array ('Percent' => ''));
			$brackets_helper->replaceInfinity($event);
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnPreSaveBrackets($event)
		{
			/** @var kBracketsHelper $brackets_helper */
			$brackets_helper = $this->Application->recallObject('BracketsHelper');

			$brackets_helper->InitHelper('FromAmount', 'ToAmount', Array('Percent' => '') );
			$brackets_helper->OnPreSaveBrackets($event);
		}
	}