<?php
/**
* @version	$Id: addresses_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'addr',
	'ItemClass' => Array ('class' => 'AddressesItem', 'file' => 'addresses_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'AddressesList', 'file' => 'addresses_list.php', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'AddressesEventHandler', 'file' => 'addresses_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'AddressesTagProcessor', 'file' => 'addresses_tag_processor.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'Hooks' => Array (
		// create/update profile address (in addresses table)
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => '#PARENT#',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterItemCreate', 'OnAfterItemUpdate'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnUpdateUserProfile',
		),
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterItemCreate', 'OnAfterItemUpdate'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnUpdateProfileAddress',
		),
		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '#PARENT#',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnModifyUsersConfig',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),
	'IDField' => 'AddressId',

	'TableName' => TABLE_PREFIX.'Addresses',

	'ParentTableKey' => 'PortalUserId', // linked field in master table
	'ForeignKey' => 'PortalUserId', // linked field in sub-table
	'ParentPrefix' => 'u',
	'AutoDelete' => true,
	'AutoClone' => true,

	'CalculatedFields' => Array (
		'' => Array (
			'ShortAddress' => 'CONCAT( TRIM(CONCAT(Address1," ",Address2)),", ",City," ...")',
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s'
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('IsProfileAddress' => 'desc')
		)
	),

	'Fields' => Array (
		'AddressId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'PortalUserId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'To' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
		'Company' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'Phone' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
		'Fax' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'Email' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'not_null' => '1', 'default' => ''),
		'Address1' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
		'Address2' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'City' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
		'State' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options' => Array (),
			'not_null' => '1', 'default' => ''
		),
		'Zip' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
		'Country' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
								FROM ' . TABLE_PREFIX . 'CountryStates
								WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
								ORDER BY Name',
			'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
			'not_null' => '1', 'required' => 1, 'default' => ''
		),
		'LastUsedAsBilling' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'LastUsedAsShipping' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'IsProfileAddress' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
	),

	'VirtualFields' => Array (
		'ShortAddress' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Fields' => Array (
				'AddressId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
				'To' => Array ('title' => 'column:la_fld_FullName', 'filter_block' => 'grid_like_filter'),
				'Company' => Array ('filter_block' => 'grid_like_filter'),
				'Phone' => Array ('filter_block' => 'grid_like_filter'),
				'Fax' => Array ('filter_block' => 'grid_like_filter'),
				'Email' => Array ('filter_block' => 'grid_like_filter'),
				'Address1' => Array ('title' => 'column:la_fld_AddressLine1', 'filter_block' => 'grid_like_filter'),
				'Address2' => Array ('title' => 'column:la_fld_AddressLine2', 'filter_block' => 'grid_like_filter'),
				'City' => Array ('filter_block' => 'grid_like_filter'),
				'State' => Array ('filter_block' => 'grid_like_filter'),
				'Zip' => Array ('filter_block' => 'grid_like_filter'),
				'Country' => Array ('filter_block' => 'grid_options_filter'),
				'LastUsedAsBilling' => Array ('filter_block' => 'grid_options_filter'),
				'LastUsedAsShipping' => Array ('filter_block' => 'grid_options_filter'),
				'IsProfileAddress' => Array ('filter_block' => 'grid_options_filter'),
			),
		),
	),
);
