<?php
/**
* @version	$Id: files_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'file',
	'ItemClass' => Array ('class' => 'FilesItem', 'file' => 'files.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'FilesEventHandler', 'file' => 'files_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'AggregateTags' => Array (
		Array (
			'AggregateTo' => '#PARENT#',
			'AggregatedTagName' => 'ListFiles',
			'LocalTagName' => 'PrintList',
			'LocalSpecial' => 'downl',
		),
	),

	/*'Hooks' => Array (
		Array (
			'Mode' => hBEFORE,
			'Conditional' => true,
			'HookToPrefix' => 'p',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'onPreSave' ),
			'DoPrefix' => 'pr',
			'DoSpecial' => 'tang',
			'DoEvent' => 'OnArrange',
		),
	),*/

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'StatusField' => Array ('Status', 'IsPrimary'),
	'IDField' => 'FileId',
	'TitleField' => 'Name',
	'TableName' => TABLE_PREFIX.'ProductFiles',
	'ForeignKey' => 'ProductId',
	'ParentTableKey' => 'ProductId',
	'ParentPrefix' => 'p',
	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSQLs' => Array (
		'' => '	SELECT *
				FROM %s'
	),

	'ListSortings' => Array (
		'' => Array (
			'ForcedSorting' => Array ('IsPrimary' => 'desc', 'Priority' => 'desc'),
			'Sorting' => Array ('AddedOn' => 'desc', 'Version' => 'desc'),
		)
	),

	'Fields' => Array (
		'FileId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'ProductId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'Name' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'Version' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'FilePath' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'RealPath' => Array (
			'type' => 'string',
			'formatter' => 'kUploadFormatter',
			'upload_dir' => ITEM_FILES_PATH, 'include_path' => 0,
			'size_field' => 'Size', 'max_size' => 50000000,
			'orig_name_field' => 'FilePath',
			'content_type_field' => 'MIMEType',
			'not_null' => 1, 'skip_empty' =>1, 'default' => '',
			'required' => 1,
			'error_msgs' => Array (
				'bad_file_format' => '!la_error_InvalidFileFormat!',
				'bad_file_size' => '!la_error_FileTooLarge!',
				'cant_save_file' => '!la_error_cant_save_file!',
			),
		),
		'Size' => Array (
			'type' => 'int',
			'formatter' => 'kFilesizeFormatter',
			'not_null' => 1, 'default' => 0,
		),
		'Status' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ( 0 => 'la_Disabled', 1 => 'la_Active', ), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'IsPrimary' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'AddedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'AddedById' => Array ('type' => 'int', 'default' => NULL),
		'MIMEType' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'0_0' => 'icon16_disabled.png',
				'0_1' => 'icon16_disabled.png',
				'1_0' => 'icon16_item.png',
				'1_1' => 'icon16_primary.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'FileId' => Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'module' => 'In-Portal', 'filter_block' => 'grid_range_filter'),
				'Name' => Array ( 'title' => 'column:la_fld_FileName', 'data_block' => 'file_caption_td', 'filter_block' => 'grid_like_filter'),
				'FilePath' => Array ( 'filter_block' => 'grid_like_filter'),
				'Version' => Array ( 'filter_block' => 'grid_like_filter'),
				'Size' => Array ( 'title' => 'la_col_Size', 'filter_block' => 'grid_range_filter'),
				'AddedOn' => Array ( 'format' => '_regional_DateFormat', 'filter_block' => 'grid_date_range_filter'),
				'Status' => Array ( 'filter_block' => 'grid_options_filter'),
			),
		),
	),
);